/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.objecttabs;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.ui.IViewPart;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Subnet;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.tools.VisibilityValidator;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.topology.widgets.SubnetAddressMap;

public class AddressMap
extends ObjectTab {
    private ScrolledComposite scroller;
    private SubnetAddressMap addressMap;

    protected void createTabContent(Composite parent) {
        this.scroller = new ScrolledComposite(parent, 768);
        this.addressMap = new SubnetAddressMap((Composite)this.scroller, 0, (IViewPart)this.getViewPart(), new VisibilityValidator(){

            public boolean isVisible() {
                return AddressMap.this.isActive();
            }
        });
        this.scroller.setContent((Control)this.addressMap);
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)512, (int)20);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)256, (int)20);
        this.scroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                AddressMap.this.scroller.setMinSize(AddressMap.this.addressMap.computeSize(-1, -1));
            }
        });
    }

    public void objectChanged(AbstractObject object) {
        if (object != null && this.isActive()) {
            this.addressMap.setSubnet((Subnet)object);
            this.scroller.setMinSize(this.addressMap.computeSize(-1, -1));
        }
    }

    public boolean showForObject(AbstractObject object) {
        return object instanceof Subnet;
    }

    public void selected() {
        super.selected();
        if (this.getObject() != null) {
            this.addressMap.setSubnet((Subnet)this.getObject());
        }
    }
}

