/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objecttools.views;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectContext;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objecttools.views.helpers.ExecutorListLabelProvider;
import org.netxms.nxmc.modules.objecttools.widgets.AbstractObjectToolExecutor;
import org.netxms.nxmc.modules.objecttools.widgets.ActionExecutor;
import org.netxms.nxmc.modules.objecttools.widgets.LocalCommandExecutor;
import org.netxms.nxmc.modules.objecttools.widgets.SSHExecutor;
import org.netxms.nxmc.modules.objecttools.widgets.ServerCommandExecutor;
import org.netxms.nxmc.modules.objecttools.widgets.ServerScriptExecutor;
import org.netxms.nxmc.modules.objecttools.widgets.helpers.ExecutorStateChangeListener;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class MultiNodeCommandExecutor
extends ObjectView {
    private I18n i18n = LocalizationHelper.getI18n(MultiNodeCommandExecutor.class);
    private SashForm splitter;
    private SortableTableViewer viewer;
    private Composite resultArea;
    private List<AbstractObjectToolExecutor> executors = new ArrayList();
    private AbstractObjectToolExecutor currentExecutor = null;
    private AbstractObjectToolExecutor.ActionSet actions;
    private Set<ObjectContext> applicableObjects;
    private Set<ObjectContext> sourceObjects;
    private ObjectTool tool;
    private Map<String, String> inputValues;
    private List<String> maskedFields;
    private List<String> expandedText;

    public MultiNodeCommandExecutor(ObjectTool tool, Set<ObjectContext> sourceObjects, Set<ObjectContext> nodes, Map<String, String> inputValues, List<String> maskedFields, List<String> expandedText) {
        super(tool.getDisplayName(), ResourceManager.getImageDescriptor((String)"icons/object-tools/terminal.png"), nodes.toString(), false);
        this.applicableObjects = nodes;
        this.tool = tool;
        this.inputValues = inputValues;
        this.maskedFields = maskedFields;
        this.expandedText = expandedText;
        this.sourceObjects = sourceObjects;
    }

    protected void createContent(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.splitter = new SashForm(parent, 512);
        Composite topPart = new Composite((Composite)this.splitter, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        topPart.setLayout((Layout)layout);
        String[] names = new String[]{"Name", "Status"};
        int[] widths = new int[]{600, 200};
        this.viewer = new SortableTableViewer(topPart, names, widths, 0, 1024, 65536);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ExecutorListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        new Label(topPart, 258).setLayoutData((Object)new GridData(4, 1024, true, false));
        Composite bottomPart = new Composite((Composite)this.splitter, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        bottomPart.setLayout((Layout)layout);
        new Label(bottomPart, 258).setLayoutData((Object)new GridData(4, 1024, true, false));
        this.resultArea = new Composite(bottomPart, 0);
        this.resultArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.resultArea.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
    }

    protected void postContentCreate() {
        this.execute();
        super.postContentCreate();
    }

    protected void createActions() {
        this.actions = new AbstractObjectToolExecutor.ActionSet();
        this.actions.actionClear = new /* Unavailable Anonymous Inner Class!! */;
        this.actions.actionScrollLock = new /* Unavailable Anonymous Inner Class!! */;
        this.actions.actionScrollLock.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/scroll-lock.png"));
        this.actions.actionScrollLock.setChecked(false);
        this.actions.actionCopy = new /* Unavailable Anonymous Inner Class!! */;
        this.actions.actionCopy.setEnabled(false);
        this.actions.actionSelectAll = new /* Unavailable Anonymous Inner Class!! */;
        this.actions.actionRestart = new /* Unavailable Anonymous Inner Class!! */;
        this.actions.actionRestart.setEnabled(false);
        this.actions.actionTerminate = new /* Unavailable Anonymous Inner Class!! */;
        this.actions.actionTerminate.setEnabled(false);
    }

    private void onSelectionChange() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection == null) {
            return;
        }
        AbstractObjectToolExecutor executor = (AbstractObjectToolExecutor)selection.getFirstElement();
        if (this.currentExecutor != executor) {
            if (this.currentExecutor != null) {
                this.currentExecutor.hide();
            }
            this.currentExecutor = executor;
            if (this.currentExecutor != null) {
                this.currentExecutor.show();
            }
        }
    }

    public void execute() {
        this.executors.clear();
        int i = 0;
        for (ObjectContext ctx : this.applicableObjects) {
            ActionExecutor executor = switch (this.tool.getToolType()) {
                case 1 -> new ActionExecutor(this.resultArea, ctx, this.actions, this.tool, this.inputValues, this.maskedFields);
                case 5 -> new LocalCommandExecutor(this.resultArea, ctx, this.actions, this.tool, (String)this.expandedText.get(i++));
                case 6 -> new ServerCommandExecutor(this.resultArea, ctx, this.actions, this.tool, this.inputValues, this.maskedFields);
                case 10 -> new SSHExecutor(this.resultArea, ctx, this.actions, this.tool, this.inputValues, this.maskedFields);
                case 8 -> new ServerScriptExecutor(this.resultArea, ctx, this.actions, this.tool, this.inputValues, this.maskedFields);
                default -> null;
            };
            executor.addStateChangeListener((ExecutorStateChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            this.executors.add(executor);
            executor.execute();
        }
        this.viewer.setInput((Object)this.executors.toArray());
        this.viewer.getTable().setSelection(0);
        this.onSelectionChange();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public boolean isValidForContext(Object context) {
        if (context != null && context instanceof AbstractObject && this.sourceObjects.size() > 0) {
            for (ObjectContext object : this.sourceObjects) {
                if (((AbstractObject)context).getObjectId() != object.object.getObjectId()) continue;
                return true;
            }
            if (((AbstractObject)context).getObjectId() == ((ObjectContext)this.sourceObjects.iterator().next()).contextId) {
                return true;
            }
        }
        return false;
    }

    public boolean isCloseable() {
        return true;
    }
}

