/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.topology.Port;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.modules.objects.widgets.ObjectPopupDialog;
import org.netxms.nxmc.modules.objects.widgets.SlotViewWidget;
import org.netxms.nxmc.modules.objects.widgets.helpers.PortCalculatorDownUpLeftRight;
import org.netxms.nxmc.modules.objects.widgets.helpers.PortCalculatorLeftRightDownUp;
import org.netxms.nxmc.modules.objects.widgets.helpers.PortCalculatorLeftRightUpDown;
import org.netxms.nxmc.modules.objects.widgets.helpers.PortCalculatorUpDownLeftRight;
import org.netxms.nxmc.modules.objects.widgets.helpers.PortInfo;
import org.netxms.nxmc.modules.objects.widgets.helpers.PortSelectionListener;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.ColorCache;
import org.netxms.nxmc.tools.WidgetHelper;

public class SlotViewWidget
extends Canvas
implements PaintListener,
MouseListener,
MouseTrackListener {
    private static final int NDD_PN_UNKNOWN = 0;
    private static final int NDD_PN_CUSTOM = 1;
    private static final int NDD_PN_LR_UD = 2;
    private static final int NDD_PN_LR_DU = 3;
    private static final int NDD_PN_UD_LR = 4;
    private static final int NDD_PN_DU_LR = 5;
    private static final int HORIZONTAL_MARGIN = 20;
    private static final int VERTICAL_MARGIN = 10;
    private static final int HORIZONTAL_SPACING = 10;
    private static final int VERTICAL_SPACING = 10;
    private static final int PORT_WIDTH = 44;
    private static final int PORT_HEIGHT = 30;
    private List<PortInfo> ports = new ArrayList();
    private int rowCount;
    private int numberingScheme;
    private String slotName;
    private Point nameSize;
    private boolean portStatusVisible = true;
    private PortInfo selection = null;
    private Set<PortSelectionListener> selectionListeners = new HashSet();
    private ColorCache colors;
    private PortLocationFinder finder = new PortLocationFinder(this);
    private AbstractObject tooltipObject = null;
    private ObjectPopupDialog tooltipDialog = null;
    private RGB colorBackground = ThemeEngine.getBackgroundColorDefinition((String)"DeviceView.Port");
    private RGB colorHighlight = ThemeEngine.getBackgroundColorDefinition((String)"DeviceView.PortHighlight");

    public SlotViewWidget(Composite parent, int style, String slotName, int rowCount, int numberingScheme) {
        super(parent, style | 0x800 | 0x20000000);
        this.slotName = slotName;
        this.numberingScheme = numberingScheme;
        this.rowCount = rowCount == 0 ? 2 : rowCount;
        this.colors = new ColorCache((Control)this);
        GC gc = new GC((Drawable)this.getDisplay());
        this.nameSize = gc.textExtent(slotName);
        gc.dispose();
        this.addPaintListener((PaintListener)this);
        this.addMouseListener((MouseListener)this);
        WidgetHelper.attachMouseTrackListener((Composite)this, (MouseTrackListener)this);
    }

    public void dispose() {
        this.removePaintListener((PaintListener)this);
        super.dispose();
    }

    public void addPort(PortInfo p) {
        this.ports.add(p);
    }

    public void paintControl(PaintEvent e) {
        e.gc.drawText(this.slotName, 20, (this.getSize().y - this.nameSize.y) / 2);
        PortCalculatorDownUpLeftRight portCalculator = null;
        switch (this.numberingScheme) {
            case 5: {
                portCalculator = new PortCalculatorDownUpLeftRight(this.nameSize.x, this.rowCount);
                break;
            }
            case 2: {
                portCalculator = new PortCalculatorLeftRightUpDown(this.nameSize.x, this.ports.size(), this.rowCount);
                break;
            }
            case 3: {
                portCalculator = new PortCalculatorLeftRightDownUp(this.nameSize.x, this.ports.size(), this.rowCount);
                break;
            }
            case 1: {
                break;
            }
            default: {
                portCalculator = new PortCalculatorUpDownLeftRight(this.nameSize.x, this.rowCount);
            }
        }
        for (PortInfo p : this.ports) {
            this.drawPort(p, portCalculator.calculateNextPos(), e.gc);
        }
    }

    private void drawPort(PortInfo p, Point point, GC gc) {
        String label = Integer.toString(p.getPort());
        Rectangle rect = new Rectangle(point.x, point.y, 44, 30);
        this.finder.addPortLocation(rect, p);
        if (p.isHighlighted()) {
            gc.setBackground(this.colors.create(this.colorHighlight));
        } else if (this.portStatusVisible) {
            ObjectStatus status = ObjectStatus.UNKNOWN;
            block0 : switch (p.getAdminState()) {
                case 2: {
                    status = ObjectStatus.DISABLED;
                    break;
                }
                case 3: {
                    status = ObjectStatus.TESTING;
                    break;
                }
                case 1: {
                    switch (p.getOperState()) {
                        case 2: {
                            status = ObjectStatus.CRITICAL;
                            break block0;
                        }
                        case 3: {
                            status = ObjectStatus.TESTING;
                            break block0;
                        }
                        case 1: {
                            status = ObjectStatus.NORMAL;
                        }
                    }
                }
            }
            gc.setBackground(StatusDisplayInfo.getStatusColor((ObjectStatus)status));
        } else {
            gc.setBackground(this.colors.create(this.colorBackground));
        }
        gc.setAlpha(127);
        gc.fillRectangle(rect);
        gc.setAlpha(255);
        gc.drawRectangle(rect);
        if (this.selection == p) {
            gc.setLineStyle(3);
            gc.drawRectangle(rect.x + 2, rect.y + 2, rect.width - 4, rect.height - 4);
            gc.setLineStyle(1);
        }
        Point ext = gc.textExtent(label);
        gc.drawText(label, point.x + (44 - ext.x) / 2, point.y + (30 - ext.y) / 2, true);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point((this.ports.size() + this.rowCount - 1) / this.rowCount * 54 + 40 + this.nameSize.x, this.rowCount * 30 + (this.rowCount - 1) * 10 + 20);
    }

    public boolean isPortStatusVisible() {
        return this.portStatusVisible;
    }

    public void setPortStatusVisible(boolean portStatusVisible) {
        this.portStatusVisible = portStatusVisible;
    }

    void clearHighlight() {
        for (PortInfo pi : this.ports) {
            pi.setHighlighted(false);
        }
    }

    void addHighlight(Port p) {
        for (PortInfo pi : this.ports) {
            if (pi.getPort() != p.getPort()) continue;
            pi.setHighlighted(true);
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        PortInfo p = this.finder.findPortInfo(e.x, e.y);
        if (p != null && p != this.selection) {
            this.selection = p;
            this.redraw();
            for (PortSelectionListener listener : this.selectionListeners) {
                listener.portSelected(p);
            }
        }
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
        if (this.tooltipDialog != null && this.tooltipDialog.getShell() != null && !this.tooltipDialog.getShell().isDisposed() && e.display.getActiveShell() != this.tooltipDialog.getShell()) {
            this.tooltipDialog.close();
            this.tooltipDialog = null;
        }
        this.tooltipObject = null;
    }

    public void mouseHover(MouseEvent e) {
        AbstractObject object;
        PortInfo p = this.finder.findPortInfo(e.x, e.y);
        AbstractObject abstractObject = object = p != null ? Registry.getSession().findObjectById(p.getInterfaceObjectId()) : null;
        if (object != null && (object != this.tooltipObject || this.tooltipDialog == null || this.tooltipDialog.getShell() == null || this.tooltipDialog.getShell().isDisposed())) {
            if (this.tooltipDialog != null && this.tooltipDialog.getShell() != null && !this.tooltipDialog.getShell().isDisposed()) {
                this.tooltipDialog.close();
            }
            this.tooltipObject = object;
            this.tooltipDialog = new ObjectPopupDialog(this.getShell(), (Object)object, this.toDisplay(e.x, e.y));
            this.tooltipDialog.open();
        } else if (object == null && this.tooltipDialog != null && this.tooltipDialog.getShell() != null && !this.tooltipDialog.getShell().isDisposed()) {
            this.tooltipDialog.close();
            this.tooltipDialog = null;
        }
    }

    public PortInfo getSelection() {
        return this.selection;
    }

    public void addSelectionListener(PortSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(PortSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }
}

