/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.elements;

import org.eclipse.swt.widgets.Composite;
import org.netxms.base.InetAddressEx;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.Chassis;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Sensor;
import org.netxms.client.objects.WirelessDomain;
import org.netxms.client.objects.Zone;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.elements.OverviewPageElement;
import org.netxms.nxmc.modules.objects.views.elements.TableElement;
import org.netxms.nxmc.modules.objects.views.helpers.InterfaceListLabelProvider;
import org.xnap.commons.i18n.I18n;

public class Communications
extends TableElement {
    private final I18n i18n = LocalizationHelper.getI18n(Communications.class);

    public Communications(Composite parent, OverviewPageElement anchor, ObjectView objectView) {
        super(parent, anchor, objectView);
    }

    public boolean isApplicableForObject(AbstractObject object) {
        return object instanceof AccessPoint || object instanceof Chassis || object instanceof Interface || object instanceof AbstractNode || object instanceof Sensor;
    }

    protected void fillTable() {
        AbstractObject object = this.getObject();
        NXCSession session = Registry.getSession();
        switch (object.getObjectClass()) {
            case 33: {
                WirelessDomain wirelessDomain;
                String vendorMac;
                AccessPoint ap = (AccessPoint)object;
                this.addPair(this.i18n.tr("MAC address"), ap.getMacAddress().toString());
                if (ap.getMacAddress() != null && !ap.getMacAddress().isNull() && (vendorMac = session.getVendorByMac(ap.getMacAddress(), null)) != null && !vendorMac.isEmpty()) {
                    this.addPair(this.i18n.tr("MAC Address Vendor"), vendorMac);
                }
                AbstractNode controller = (AbstractNode)session.findObjectById(ap.getControllerId(), AbstractNode.class);
                if (ap.getIpAddress().isValidAddress()) {
                    if (session.isZoningEnabled() && controller != null) {
                        this.addPair(this.i18n.tr("Zone UIN"), this.getZoneName(controller.getZoneId()));
                    }
                    this.addPair(this.i18n.tr("IP address"), ap.getIpAddress().getHostAddress());
                }
                if (controller != null) {
                    this.addPair(this.i18n.tr("Controller"), controller.getObjectName());
                }
                if ((wirelessDomain = (WirelessDomain)session.findObjectById(ap.getWirelessDomainId(), WirelessDomain.class)) == null) break;
                this.addPair(this.i18n.tr("Wireless domain"), wirelessDomain.getObjectName());
                break;
            }
            case 35: {
                AbstractNode node;
                Chassis chassis = (Chassis)object;
                if (chassis.getControllerId() == 0L || (node = (AbstractNode)session.findObjectById(chassis.getControllerId(), AbstractNode.class)) == null) break;
                this.addPair(this.i18n.tr("Controller"), node.getObjectName());
                break;
            }
            case 3: {
                String vendor;
                Interface iface = (Interface)object;
                this.addPair(this.i18n.tr("MAC address"), iface.getMacAddress().toString());
                if (iface.getMacAddress() != null && !iface.getMacAddress().isNull() && (vendor = session.getVendorByMac(iface.getMacAddress(), null)) != null && !vendor.isEmpty()) {
                    this.addPair(this.i18n.tr("MAC Address Vendor"), vendor);
                }
                this.addPair("VLAN", InterfaceListLabelProvider.getVlanList((Interface)iface), false);
                if (iface.getIpAddressList().size() > 0) {
                    if (session.isZoningEnabled()) {
                        this.addPair(this.i18n.tr("Zone UIN"), this.getZoneName(iface.getZoneId()));
                    }
                    this.addPair(this.i18n.tr("IP address"), ((InetAddressEx)iface.getIpAddressList().get(0)).toString());
                    for (int i = 1; i < iface.getIpAddressList().size(); ++i) {
                        this.addPair("", ((InetAddressEx)iface.getIpAddressList().get(i)).toString());
                    }
                }
                if (!iface.isOSPF()) break;
                this.addPair(this.i18n.tr("OSPF area"), iface.getOSPFArea().getHostAddress());
                this.addPair(this.i18n.tr("OSPF interface type"), iface.getOSPFType().getText(), false);
                break;
            }
            case 2: {
                AbstractNode node = (AbstractNode)object;
                if (session.isZoningEnabled()) {
                    this.addPair(this.i18n.tr("Zone UIN"), this.getZoneName(node.getZoneId()));
                }
                this.addPair(this.i18n.tr("Primary host name"), node.getPrimaryName());
                this.addPair(this.i18n.tr("Primary IP address"), node.getPrimaryIP().getHostAddress());
                if (!node.isIcmpStatisticsCollected()) break;
                this.addPair(this.i18n.tr("ICMP average response time"), node.getIcmpAverageResponseTime() + " ms");
                this.addPair(this.i18n.tr("ICMP packet loss"), node.getIcmpPacketLoss() + "%");
                break;
            }
            case 37: {
                Sensor sensor = (Sensor)object;
                if (sensor.getGatewayId() != 0L) {
                    AbstractNode gatewayNode = (AbstractNode)session.findObjectById(sensor.getGatewayId(), AbstractNode.class);
                    if (gatewayNode != null) {
                        this.addPair(this.i18n.tr("Gateway"), gatewayNode.getObjectName());
                    }
                    this.addPair("Modbus Unit ID", Integer.toString(sensor.getModbusUnitId()));
                }
                this.addPair(this.i18n.tr("Device address"), sensor.getDeviceAddress(), false);
                if (sensor.getMacAddress() == null || sensor.getMacAddress().isNull()) break;
                this.addPair(this.i18n.tr("MAC address"), sensor.getMacAddress().toString(), true);
                String vendorMac = session.getVendorByMac(sensor.getMacAddress(), null);
                if (vendorMac == null || vendorMac.isEmpty()) break;
                this.addPair(this.i18n.tr("MAC Address Vendor"), vendorMac);
                break;
            }
        }
    }

    protected String getTitle() {
        return this.i18n.tr("Communications");
    }

    private String getZoneName(int zoneId) {
        Zone zone = Registry.getSession().findZone(zoneId);
        if (zone == null) {
            return Long.toString(zoneId);
        }
        return String.format("%d (%s)", zoneId, zone.getObjectName());
    }
}

