/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.datacollection.DciValue;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.widgets.DciList;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.widgets.ObjectTree;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class SelectDciDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(SelectDciDialog.class);
    private SashForm splitter;
    private ObjectTree objectTree;
    private DciList dciList;
    private List<DciValue> selection;
    private int dcObjectType = -1;
    private long fixedNode;
    private boolean enableEmptySelection = false;
    private boolean allowTemplateItems = false;
    private boolean allowSingleSelection = false;
    private boolean allowNoValueObjects = false;

    public SelectDciDialog(Shell parentShell, long fixedNode) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fixedNode = fixedNode;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Select DCI"));
        PreferenceStore settings = PreferenceStore.getInstance();
        newShell.setSize(settings.getAsInteger("SelectDciDialog.width", 600), settings.getAsInteger("SelectDciDialog.height", 350));
        newShell.setLocation(settings.getAsInteger("SelectDciDialog.cx", 100), settings.getAsInteger("SelectDciDialog.cy", 100));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.enableEmptySelection) {
            Button button = this.createButton(parent, 1000, this.i18n.tr("&None"), false);
            button.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        super.createButtonsForButtonBar(parent);
    }

    protected Control createDialogArea(Composite parent) {
        PreferenceStore settings = PreferenceStore.getInstance();
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new FillLayout());
        if (this.fixedNode == 0L) {
            this.splitter = new SashForm(dialogArea, 256);
            this.objectTree = new ObjectTree((Composite)this.splitter, 2048, false, this.allowTemplateItems ? ObjectSelectionDialog.createDataCollectionOwnerSelectionFilter() : ObjectSelectionDialog.createDataCollectionTargetSelectionFilter(), null, null, true, false);
            String text = settings.getAsString("SelectDciDialog.Filter");
            if (text != null) {
                this.objectTree.setFilterText(text);
            }
        }
        this.dciList = new DciList(null, (Composite)(this.fixedNode == 0L ? this.splitter : dialogArea), 2048, null, "SelectDciDialog.dciList", this.dcObjectType, this.allowSingleSelection ? 0 : 2, this.allowNoValueObjects);
        this.dciList.setDcObjectType(this.dcObjectType);
        this.dciList.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.fixedNode == 0L) {
            int[] weights = new int[]{settings.getAsInteger("SelectDciDialog.weight1", 30), settings.getAsInteger("SelectDciDialog.weight2", 70)};
            this.splitter.setWeights(weights);
            this.objectTree.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
            this.objectTree.setFocus();
        } else {
            this.dciList.setNode(Registry.getSession().findObjectById(this.fixedNode));
        }
        return dialogArea;
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        Point pleace = this.getShell().getLocation();
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set("SelectDciDialog.cx", pleace.x);
        settings.set("SelectDciDialog.cy", pleace.y);
        settings.set("SelectDciDialog.width", size.x);
        settings.set("SelectDciDialog.height", size.y);
        if (this.fixedNode == 0L) {
            settings.set("SelectDciDialog.Filter", this.objectTree.getFilterText());
            int[] weights = this.splitter.getWeights();
            settings.set("SelectDciDialog.weight1", weights[0]);
            settings.set("SelectDciDialog.weight2", weights[1]);
        }
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.selection = this.dciList.getSelection();
        if (this.selection == null || this.selection.size() == 0) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please select DCI from the list and then press OK"));
            return;
        }
        this.saveSettings();
        super.okPressed();
    }

    public List<DciValue> getSelection() {
        return this.selection;
    }

    public int getDcObjectType() {
        return this.dcObjectType;
    }

    public void setDcObjectType(int dcObjectType) {
        this.dcObjectType = dcObjectType;
        if (this.dciList != null) {
            this.dciList.setDcObjectType(dcObjectType);
        }
    }

    public final boolean isEnableEmptySelection() {
        return this.enableEmptySelection;
    }

    public final void setEnableEmptySelection(boolean enableEmptySelection) {
        this.enableEmptySelection = enableEmptySelection;
    }

    public final boolean isAllowTemplateItems() {
        return this.allowTemplateItems;
    }

    public final void setAllowTemplateItems(boolean allowTemplateItems) {
        this.allowTemplateItems = allowTemplateItems;
    }

    public void setSingleSelection(boolean allowSingleSelection) {
        this.allowSingleSelection = allowSingleSelection;
    }

    public void setAllowNoValueObjects(boolean allowNoValueObjects) {
        this.allowNoValueObjects = allowNoValueObjects;
    }

    static /* synthetic */ void access$001(SelectDciDialog x0) {
        super.okPressed();
    }
}

