/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.dialogs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.dialogs.ThemeEditDialog;
import org.netxms.nxmc.base.dialogs.ThemeElementEditDialog;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.resources.Theme;
import org.netxms.nxmc.resources.ThemeElement;

public class ThemeEditDialog
extends Dialog {
    public static final int COLUMN_TAG = 0;
    public static final int COLUMN_FOREGROUND = 1;
    public static final int COLUMN_BACKGROUND = 2;
    public static final int COLUMN_FONT = 3;
    private Theme theme;
    private LabeledText name;
    private TableViewer viewer;
    private Map<String, ThemeElement> changedElements = new HashMap();

    public ThemeEditDialog(Shell parentShell, Theme theme) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.theme = theme;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit Theme");
        PreferenceStore settings = PreferenceStore.getInstance();
        newShell.setSize(settings.getAsInteger("ThemeEditDialog.cx", 670), settings.getAsInteger("ThemeEditDialog.cy", 600));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 2;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel("Name");
        this.name.setText(this.theme.getName());
        this.name.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label = new Label(dialogArea, 0);
        label.setText("Theme elements");
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        label.setLayoutData((Object)gd);
        this.viewer = new TableViewer(dialogArea, 67584);
        this.setupViewer();
        this.viewer.setInput((Object)this.theme.getTags());
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    private void setupViewer() {
        TableColumn column = new TableColumn(this.viewer.getTable(), 16384);
        column.setText("Tag");
        column.setWidth(400);
        column = new TableColumn(this.viewer.getTable(), 16384);
        column.setText("FG");
        column.setWidth(50);
        column = new TableColumn(this.viewer.getTable(), 16384);
        column.setText("BG");
        column.setWidth(50);
        column = new TableColumn(this.viewer.getTable(), 16384);
        column.setText("Font");
        column.setWidth(150);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ColorListLabelProvider(this));
        this.viewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set("ThemeEditDialog.cx", size.x);
        settings.set("ThemeEditDialog.cy", size.y);
    }

    private void editElement() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        String tag = (String)selection.getFirstElement();
        ThemeElement element = new ThemeElement(this.changedElements.containsKey(tag) ? (ThemeElement)this.changedElements.get(tag) : this.theme.getElement(tag));
        ThemeElementEditDialog dlg = new ThemeElementEditDialog(this.getShell(), element);
        if (dlg.open() == 0) {
            this.changedElements.put(tag, element);
            this.viewer.update((Object)tag, null);
        }
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.saveSettings();
        this.theme.setName(this.name.getText().trim());
        for (Map.Entry e : this.changedElements.entrySet()) {
            this.theme.setElement((String)e.getKey(), (ThemeElement)e.getValue());
        }
        super.okPressed();
    }
}

