/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.TimePeriod;
import org.netxms.client.constants.TimeFrameType;
import org.netxms.client.constants.TimeUnit;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.widgets.TimePeriodSelector;

public class TimePeriodCompactSelector
extends Composite {
    private static final TimePeriod[] PRESETS = new TimePeriod[]{new TimePeriod(TimeFrameType.BACK_FROM_NOW, 1, TimeUnit.HOUR, null, null), new TimePeriod(TimeFrameType.BACK_FROM_NOW, 4, TimeUnit.HOUR, null, null), new TimePeriod(TimeFrameType.BACK_FROM_NOW, 12, TimeUnit.HOUR, null, null), new TimePeriod(TimeFrameType.BACK_FROM_NOW, 1, TimeUnit.DAY, null, null), new TimePeriod(TimeFrameType.BACK_FROM_NOW, 7, TimeUnit.DAY, null, null), new TimePeriod(TimeFrameType.BACK_FROM_NOW, 30, TimeUnit.DAY, null, null), new TimePeriod(TimeFrameType.BACK_FROM_NOW, 90, TimeUnit.DAY, null, null)};
    private TimePeriod timePeriod;
    private Button description;
    private Shell selectorShell;
    private Set<SelectionListener> selectionListeners = new HashSet<SelectionListener>();

    public TimePeriodCompactSelector(Composite parent, int style) {
        this(parent, style, new TimePeriod(TimeFrameType.BACK_FROM_NOW, 1, TimeUnit.HOUR, null, null));
    }

    public TimePeriodCompactSelector(Composite parent, int style, TimePeriod initialTimePeriod) {
        super(parent, style);
        this.timePeriod = initialTimePeriod;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.description = new Button((Composite)this, 0x800008);
        this.description.setLayoutData((Object)new GridData(4, 4, true, false));
        this.description.setCursor(this.getDisplay().getSystemCursor(21));
        this.description.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TimePeriodCompactSelector.this.selectorShell == null) {
                    TimePeriodCompactSelector.this.showSelector();
                } else {
                    TimePeriodCompactSelector.this.selectorShell.dispose();
                }
            }
        });
        this.updateDescription();
    }

    private void showSelector() {
        Button buttonCancel;
        Button buttonApply;
        this.selectorShell = new Shell(this.getShell(), 8);
        this.selectorShell.setLayout((Layout)new FillLayout());
        this.selectorShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TimePeriodCompactSelector.this.selectorShell = null;
                TimePeriodCompactSelector.this.updateDescription();
            }
        });
        Composite content = new Composite((Composite)this.selectorShell, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 2;
        content.setLayout((Layout)layout);
        Label presetsLabel = new Label(content, 0);
        presetsLabel.setText("Presets");
        final TimePeriodSelector selector = new TimePeriodSelector(content, 512, this.timePeriod);
        selector.setLayoutData(new GridData(4, 4, true, true, 1, 2));
        final List presetList = new List(content, 67584);
        GridData gd = new GridData();
        gd.widthHint = 200;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        presetList.setLayoutData((Object)gd);
        TimePeriod[] timePeriodArray = PRESETS;
        int n = PRESETS.length;
        int n2 = 0;
        while (n2 < n) {
            TimePeriod p = timePeriodArray[n2];
            presetList.add(this.describeTimePeriod(p));
            ++n2;
        }
        presetList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                selector.setTimePeriod(PRESETS[presetList.getSelectionIndex()]);
            }
        });
        presetList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TimePeriodCompactSelector.this.timePeriod = PRESETS[presetList.getSelectionIndex()];
                TimePeriodCompactSelector.this.selectorShell.dispose();
                TimePeriodCompactSelector.this.fireSelectionListeners();
            }
        });
        Composite buttonBar = new Composite(content, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        buttonBar.setLayout((Layout)layout);
        gd = new GridData(131072, 4, true, false, 2, 1);
        gd.verticalIndent = 6;
        buttonBar.setLayoutData((Object)gd);
        if (Platform.getOS().equals("win32")) {
            buttonApply = new Button(buttonBar, -1);
            buttonCancel = new Button(buttonBar, 8);
        } else {
            buttonCancel = new Button(buttonBar, 8);
            buttonApply = new Button(buttonBar, -1);
        }
        this.selectorShell.setDefaultButton(buttonApply);
        buttonApply.setText("&Apply");
        gd = new GridData();
        gd.widthHint = 90;
        buttonApply.setLayoutData((Object)gd);
        buttonApply.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimePeriodCompactSelector.this.timePeriod = selector.getTimePeriod();
                TimePeriodCompactSelector.this.selectorShell.dispose();
                TimePeriodCompactSelector.this.fireSelectionListeners();
            }
        });
        buttonCancel.setText("Cancel");
        gd = new GridData();
        gd.widthHint = 90;
        buttonCancel.setLayoutData((Object)gd);
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimePeriodCompactSelector.this.selectorShell.dispose();
            }
        });
        this.selectorShell.pack();
        Point shellSize = this.selectorShell.getSize();
        Rectangle displayBounds = this.getDisplay().getBounds();
        Point l = this.getLocation();
        l.y += this.getSize().y + 1;
        l = this.getDisplay().map((Control)this.getParent(), null, l);
        if (l.x + shellSize.x >= displayBounds.width) {
            l.x = displayBounds.width - shellSize.x - 1;
        }
        if (l.y + shellSize.y >= displayBounds.height) {
            l.y = displayBounds.height - shellSize.y - 1;
        }
        this.selectorShell.setLocation(l);
        this.updateDescription();
        this.selectorShell.open();
    }

    private void updateDescription() {
        if (this.description.isDisposed()) {
            return;
        }
        this.description.setText(String.valueOf(this.describeTimePeriod(this.timePeriod)) + (this.selectorShell != null ? "  \u25b4" : "  \u25be"));
        this.getParent().layout();
    }

    private String describeTimePeriod(TimePeriod p) {
        StringBuilder sb = new StringBuilder();
        if (p.isBackFromNow()) {
            sb.append("Last ");
            if (p.getTimeRange() == 1) {
                switch (p.getTimeUnit()) {
                    case DAY: {
                        sb.append("day");
                        break;
                    }
                    case HOUR: {
                        sb.append("hour");
                        break;
                    }
                    case MINUTE: {
                        sb.append("minute");
                    }
                }
            } else if (p.getTimeRange() == 7 && p.getTimeUnit() == TimeUnit.DAY) {
                sb.append(" week");
            } else {
                sb.append(p.getTimeRange());
                switch (p.getTimeUnit()) {
                    case DAY: {
                        sb.append(" days");
                        break;
                    }
                    case HOUR: {
                        sb.append(" hours");
                        break;
                    }
                    case MINUTE: {
                        sb.append(" minutes");
                    }
                }
            }
        } else {
            sb.append(RegionalSettings.getDateTimeFormat().format(p.getPeriodStart()));
            sb.append(" \u2013 ");
            sb.append(RegionalSettings.getDateTimeFormat().format(p.getPeriodEnd()));
        }
        return sb.toString();
    }

    public TimePeriod getTimePeriod() {
        return this.timePeriod;
    }

    public void setTimePeriod(TimePeriod timePeriod) {
        this.timePeriod = timePeriod;
        this.updateDescription();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    private void fireSelectionListeners() {
        Event e = new Event();
        e.display = this.getDisplay();
        e.doit = true;
        e.widget = this;
        SelectionEvent se = new SelectionEvent(e);
        for (SelectionListener l : this.selectionListeners) {
            l.widgetSelected(se);
        }
    }
}

