/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.helpers;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.DciValue;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.console.resources.ThemeEngine;

public class OverviewDciLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return ((DciValue)element).getErrorCount() > 0 ? StatusDisplayInfo.getStatusImage((ObjectStatus)ObjectStatus.UNKNOWN) : StatusDisplayInfo.getStatusImage((Severity)((DciValue)element).getThresholdSeverity());
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DciValue dci = (DciValue)element;
        switch (columnIndex) {
            case 0: {
                return dci.getDescription();
            }
            case 1: {
                return dci.getFormattedValue(true, RegionalSettings.TIME_FORMATTER);
            }
            case 2: {
                if (dci.getTimestamp().getTime() <= 1000L) {
                    return null;
                }
                return RegionalSettings.getDateTimeFormat().format(dci.getTimestamp());
            }
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (((DciValue)element).getErrorCount() > 0) {
            return ThemeEngine.getForegroundColor((String)"List.Error");
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

