/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.snmp.views.helpers;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.NXCSession;
import org.netxms.client.events.EventTemplate;
import org.netxms.client.snmp.SnmpTrap;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class SnmpTrapComparator
extends ViewerComparator {
    private I18n i18n = LocalizationHelper.getI18n(SnmpTrapComparator.class);
    private NXCSession session = Registry.getSession();

    public int compare(Viewer viewer, Object e1, Object e2) {
        TableColumn sortColumn = ((TableViewer)viewer).getTable().getSortColumn();
        if (sortColumn == null) {
            return 0;
        }
        SnmpTrap trap1 = (SnmpTrap)e1;
        SnmpTrap trap2 = (SnmpTrap)e2;
        int rc = switch ((Integer)sortColumn.getData("ID")) {
            case 0 -> Long.signum(trap1.getId() - trap2.getId());
            case 1 -> trap1.getObjectId().compareTo(trap2.getObjectId());
            case 2 -> {
                EventTemplate evt1 = this.session.findEventTemplateByCode((long)trap1.getEventCode());
                EventTemplate evt2 = this.session.findEventTemplateByCode((long)trap2.getEventCode());
                String name1 = evt1 != null ? evt1.getName() : this.i18n.tr("Unknown");
                String name2 = evt2 != null ? evt2.getName() : this.i18n.tr("Unknown");
                yield name1.compareToIgnoreCase(name2);
            }
            case 3 -> trap1.getDescription().compareToIgnoreCase(trap2.getDescription());
            default -> 0;
        };
        int dir = ((TableViewer)viewer).getTable().getSortDirection();
        return dir == 128 ? rc : -rc;
    }
}

