/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.widgets.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.gef4.zest.core.viewers.IGraphEntityRelationshipContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.maps.MapObjectDisplayMode;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapDCIContainer;
import org.netxms.client.maps.elements.NetworkMapDCIImage;
import org.netxms.client.maps.elements.NetworkMapDecoration;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.maps.elements.NetworkMapTextBox;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.ExtendedGraphViewer;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.MapLabelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapContentProvider
implements IGraphEntityRelationshipContentProvider {
    private static final Logger logger = LoggerFactory.getLogger(MapContentProvider.class);
    private ExtendedGraphViewer viewer;
    private NetworkMapPage page;
    private Map<Long, DciValue[]> cachedDciValues = new HashMap();
    private NXCSession session = Registry.getSession();
    private Thread syncThread = null;
    private volatile boolean syncRunning = true;
    private MapLabelProvider labelProvider;

    public MapContentProvider(ExtendedGraphViewer viewer, MapLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
        this.viewer = viewer;
        Display display = viewer.getControl().getDisplay();
        this.syncThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.syncThread.setDaemon(true);
        this.syncThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncData(Display display) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            return;
        }
        while (this.syncRunning) {
            HashSet dataSyncSet = new HashSet();
            Map map = this.cachedDciValues;
            synchronized (map) {
                if (this.labelProvider.getObjectFigureType() == MapObjectDisplayMode.LARGE_LABEL && !this.cachedDciValues.isEmpty()) {
                    dataSyncSet.addAll(this.cachedDciValues.keySet());
                }
            }
            if (!dataSyncSet.isEmpty()) {
                try {
                    Map values = this.session.getTooltipLastValues(this.cachedDciValues.keySet());
                    display.asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                }
                catch (Exception e) {
                    logger.error("Exception in map data synchronization task", (Throwable)e);
                }
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DciValue[] getNodeLastValues(long nodeId) {
        Map map = this.cachedDciValues;
        synchronized (map) {
            return (DciValue[])this.cachedDciValues.get(nodeId);
        }
    }

    public Object[] getElements(Object inputElement) {
        if (!(inputElement instanceof NetworkMapPage)) {
            return null;
        }
        ArrayList<NetworkMapElement> elements = new ArrayList<NetworkMapElement>(((NetworkMapPage)inputElement).getElements().size());
        for (NetworkMapElement e : ((NetworkMapPage)inputElement).getElements()) {
            if (e instanceof NetworkMapDecoration || e instanceof NetworkMapDCIContainer || e instanceof NetworkMapDCIImage || e instanceof NetworkMapTextBox) continue;
            elements.add(e);
        }
        return elements.toArray();
    }

    public Object[] getRelationships(Object source, Object dest) {
        return this.page.findLinks((NetworkMapElement)source, (NetworkMapElement)dest).toArray();
    }

    public void dispose() {
        this.syncRunning = false;
        this.syncThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (oldInput instanceof NetworkMapPage && newInput instanceof NetworkMapPage) {
            this.page = (NetworkMapPage)newInput;
            NetworkMapPage oldPage = (NetworkMapPage)oldInput;
            Map map = this.cachedDciValues;
            synchronized (map) {
                for (NetworkMapElement e : oldPage.getElements()) {
                    if (!(e instanceof NetworkMapObject)) continue;
                    boolean found = false;
                    long id = ((NetworkMapObject)e).getObjectId();
                    for (NetworkMapElement e2 : this.page.getElements()) {
                        if (!(e2 instanceof NetworkMapObject) || id != ((NetworkMapObject)e2).getObjectId()) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.cachedDciValues.remove(id);
                }
            }
        }
        if (newInput instanceof NetworkMapPage) {
            this.page = (NetworkMapPage)newInput;
            Map map = this.cachedDciValues;
            synchronized (map) {
                for (NetworkMapElement e : this.page.getElements()) {
                    long id;
                    AbstractObject object;
                    if (!(e instanceof NetworkMapObject) || (object = this.session.findObjectById(id = ((NetworkMapObject)e).getObjectId(), true)) == null || !(object instanceof AbstractNode) || this.cachedDciValues.containsKey(id)) continue;
                    this.cachedDciValues.put(id, null);
                }
            }
        } else {
            this.page = null;
        }
    }

    public List<NetworkMapElement> getDecorations(Object inputElement) {
        if (!(inputElement instanceof NetworkMapPage)) {
            return null;
        }
        ArrayList<NetworkMapElement> elements = new ArrayList<NetworkMapElement>(((NetworkMapPage)inputElement).getElements().size());
        for (NetworkMapElement e : ((NetworkMapPage)inputElement).getElements()) {
            if (!(e instanceof NetworkMapDecoration) && !(e instanceof NetworkMapDCIContainer) && !(e instanceof NetworkMapDCIImage) && !(e instanceof NetworkMapTextBox)) continue;
            elements.add(e);
        }
        return elements;
    }
}

