/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import java.util.Arrays;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Sensor;
import org.netxms.client.xml.XMLTools;
import org.netxms.nxmc.modules.charts.api.ChartColor;
import org.netxms.nxmc.modules.charts.api.ChartType;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.ObjectStatusChartConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.ComparisonChartElement;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStatusChartElement
extends ComparisonChartElement {
    private static final Logger logger = LoggerFactory.getLogger(ObjectStatusChartElement.class);
    private ObjectStatusChartConfig elementConfig;

    public ObjectStatusChartElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, element, view);
        try {
            this.elementConfig = (ObjectStatusChartConfig)XMLTools.createFromXml(ObjectStatusChartConfig.class, (String)element.getData());
        }
        catch (Exception e) {
            logger.error("Cannot parse dashboard element configuration", (Throwable)e);
            this.elementConfig = new ObjectStatusChartConfig();
        }
        this.processCommonSettings((DashboardElementConfig)this.elementConfig);
        this.refreshInterval = this.elementConfig.getRefreshRate();
        ChartConfiguration chartConfig = new ChartConfiguration();
        chartConfig.setTitleVisible(false);
        chartConfig.setLegendPosition(2);
        chartConfig.setLegendVisible(this.elementConfig.isShowLegend());
        chartConfig.setTransposed(this.elementConfig.isTransposed());
        chartConfig.setTranslucent(this.elementConfig.isTranslucent());
        this.chart = new Chart(this.getContentArea(), 0, ChartType.BAR, chartConfig);
        for (int i = 0; i <= ObjectStatus.UNKNOWN.getValue(); ++i) {
            this.chart.addParameter(new GraphItem(StatusDisplayInfo.getStatusText((int)i), StatusDisplayInfo.getStatusText((int)i), null));
            this.chart.setPaletteEntry(i, new ChartColor(StatusDisplayInfo.getStatusColor((int)i).getRGB()));
        }
        this.chart.rebuild();
        this.startRefreshTimer();
    }

    protected ChartDciConfig[] getDciList() {
        return null;
    }

    protected void refreshData() {
        int[] objectCount = new int[6];
        Arrays.fill(objectCount, 0);
        AbstractObject root = this.session.findObjectById(this.getEffectiveObjectId(this.elementConfig.getRootObject()));
        if (root != null) {
            this.collectData(objectCount, root);
        }
        for (int i = 0; i < objectCount.length; ++i) {
            this.chart.updateParameter(i, (double)objectCount[i], false);
        }
        this.chart.refresh();
    }

    private void collectData(int[] objectCount, AbstractObject root) {
        for (AbstractObject o : root.getAllChildren(-1)) {
            if (o.getStatus().compareTo((Enum)ObjectStatus.UNKNOWN) > 0 || !this.filterObject(o)) continue;
            int n = o.getStatus().getValue();
            objectCount[n] = objectCount[n] + 1;
        }
    }

    private boolean filterObject(AbstractObject o) {
        return o instanceof Node || o instanceof MobileDevice || o instanceof Sensor || o instanceof AccessPoint;
    }
}

