/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import java.lang.reflect.Constructor;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.xml.XMLTools;
import org.netxms.nxmc.modules.dashboards.api.CustomDashboardElement;
import org.netxms.nxmc.modules.dashboards.config.CustomWidgetConfig;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.ElementWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomWidgetElement
extends ElementWidget {
    private static final Logger logger = LoggerFactory.getLogger(CustomWidgetElement.class);

    public CustomWidgetElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, 0, element, view);
        CustomWidgetConfig config;
        try {
            config = (CustomWidgetConfig)XMLTools.createFromXml(CustomWidgetConfig.class, (String)element.getData());
        }
        catch (Exception e) {
            logger.error("Cannot parse dashboard element configuration", (Throwable)e);
            config = new CustomWidgetConfig();
        }
        this.processCommonSettings((DashboardElementConfig)config);
        try {
            Class<?> widgetClass = Class.forName(config.getClassName());
            if (CustomDashboardElement.class.isAssignableFrom(widgetClass)) {
                Constructor<?> c = widgetClass.getConstructor(Composite.class, String.class);
                c.newInstance(this.getContentArea(), element.getData());
            } else {
                logger.error("Cannot instantiate widget for custom dashboard element - class " + config.getClassName() + " is not assignable to CustomDashboardElement");
            }
        }
        catch (Exception e) {
            logger.error("Cannot instantiate widget for custom dashboard element", (Throwable)e);
        }
    }
}

