/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.assetmanagement.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Asset;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.modules.assetmanagement.views.helpers.AssetPropertyReader;
import org.netxms.nxmc.modules.objects.widgets.helpers.BaseObjectLabelProvider;

public class AssetListLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private SortableTableViewer viewer;
    private AssetPropertyReader propertyReader;
    private NXCSession session = Registry.getSession();
    private BaseObjectLabelProvider objectLabelProvider = new BaseObjectLabelProvider();

    public AssetListLabelProvider(SortableTableViewer viewer, AssetPropertyReader propertyReader) {
        this.viewer = viewer;
        this.propertyReader = propertyReader;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.objectLabelProvider.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.objectLabelProvider.getText(element);
        }
        String attribute = (String)this.viewer.getColumnById(columnIndex).getData("Attribute");
        if (attribute == null) {
            return null;
        }
        Asset asset = this.getAsset(element);
        if (asset == null) {
            return null;
        }
        return this.propertyReader.valueToText(attribute, (String)asset.getProperties().get(attribute));
    }

    private Asset getAsset(Object element) {
        if (element instanceof Asset) {
            return (Asset)element;
        }
        return (Asset)this.session.findObjectById(((AbstractObject)element).getAssetId(), Asset.class);
    }

    public void dispose() {
        this.objectLabelProvider.dispose();
        super.dispose();
    }
}

