/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps.configs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netxms.client.maps.configs.SingleDciConfig;
import org.netxms.client.xml.XMLTools;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="config", strict=false)
public class LinkConfig {
    @ElementArray(required=false)
    private SingleDciConfig[] dciList;
    @ElementList(required=false)
    private List<Long> objectStatusList = new ArrayList<Long>();
    @Element(required=false)
    private int routing;
    @Element(required=false)
    private long[] bendPoints;
    @Element(required=false)
    private boolean useActiveThresholds;
    @Element(required=false)
    private boolean useInterfaceUtilization;
    @Element(required=false)
    private int labelPosition = 50;
    @Element(required=false)
    private int style = 0;
    @Element(required=false)
    private int width = 0;

    public LinkConfig() {
        this.routing = 0;
        this.bendPoints = null;
        this.dciList = null;
        this.useActiveThresholds = false;
        this.useInterfaceUtilization = false;
    }

    public LinkConfig(SingleDciConfig[] dciList, List<Long> objectStatusList, int routing, long[] bendPoints, boolean useActiveThresholds, boolean useInterfaceUtilization, boolean isLocked) {
        this.dciList = dciList;
        this.objectStatusList = objectStatusList;
        this.routing = routing;
        this.bendPoints = bendPoints;
        this.useActiveThresholds = useActiveThresholds;
        this.useInterfaceUtilization = useInterfaceUtilization;
    }

    public String createXml() throws Exception {
        return XMLTools.serialize(this);
    }

    public List<Long> getObjectStatusList() {
        return this.objectStatusList != null ? this.objectStatusList : new ArrayList(0);
    }

    public void setObjectStatusList(List<Long> objectStatusList) {
        this.objectStatusList = objectStatusList;
    }

    public SingleDciConfig[] getDciList() {
        return this.dciList;
    }

    public void setDciList(SingleDciConfig[] dciList) {
        this.dciList = dciList;
    }

    public int getRouting() {
        return this.routing;
    }

    public void setRouting(int routing) {
        this.routing = routing;
    }

    public long[] getBendPoints() {
        return this.bendPoints;
    }

    public void setBendPoints(long[] bendPoints) {
        this.bendPoints = bendPoints;
    }

    public void setUseActiveThresholds(boolean useActiveThresholds) {
        this.useActiveThresholds = useActiveThresholds;
    }

    public boolean isUseActiveThresholds() {
        return this.useActiveThresholds;
    }

    public boolean isUseInterfaceUtilization() {
        return this.useInterfaceUtilization;
    }

    public void setUseInterfaceUtilization(boolean useInterfaceUtilization) {
        this.useInterfaceUtilization = useInterfaceUtilization;
    }

    public int getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(int labelPosition) {
        this.labelPosition = labelPosition;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String toString() {
        return "LinkConfig [dciList=" + Arrays.toString(this.dciList) + ", objectStatusList=" + this.objectStatusList.toString() + ", routing=" + this.routing + ", bendPoints=" + Arrays.toString(this.bendPoints) + ", labelPosition=" + this.labelPosition + ", lineStyle=" + this.style + ", lineWidth=" + this.width + "]";
    }
}

