/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.propertypages.helpers.AbstractDCIPropertyPage;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.widgets.LabeledCombo;

public class OtherOptions
extends AbstractDCIPropertyPage {
    private static final String[] TAGS = new String[]{"iface-inbound-bits", "iface-inbound-bytes", "iface-inbound-util", "iface-outbound-bits", "iface-outbound-bytes", "iface-outbound-util", "iface-speed"};
    private DataCollectionItem dci;
    private Button checkShowOnTooltip;
    private Button checkShowInOverview;
    private Button checkCalculateStatus;
    private Button checkHideOnLastValues;
    private LabeledCombo multiplierDegree;
    private LabeledCombo agentCacheMode;
    private LabeledCombo interpretation;
    private ObjectSelector relatedObject;

    @Override
    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dci = this.editor.getObjectAsItem();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkShowOnTooltip = new Button(dialogArea, 32);
        Messages.get();
        this.checkShowOnTooltip.setText(Messages.NetworkMaps_ShowInTooltips);
        this.checkShowOnTooltip.setSelection(this.dci.isShowOnObjectTooltip());
        this.checkShowInOverview = new Button(dialogArea, 32);
        Messages.get();
        this.checkShowInOverview.setText(Messages.OtherOptions_ShowlastValueInObjectOverview);
        this.checkShowInOverview.setSelection(this.dci.isShowInObjectOverview());
        this.checkCalculateStatus = new Button(dialogArea, 32);
        Messages.get();
        this.checkCalculateStatus.setText(Messages.OtherOptions_UseForStatusCalculation);
        this.checkCalculateStatus.setSelection(this.dci.isUsedForNodeStatusCalculation());
        this.checkHideOnLastValues = new Button(dialogArea, 32);
        this.checkHideOnLastValues.setText("Hide value on \"Last Values\" page");
        this.checkHideOnLastValues.setSelection(this.dci.isHideOnLastValuesView());
        this.agentCacheMode = new LabeledCombo(dialogArea, 0);
        Messages.get();
        this.agentCacheMode.setLabel(Messages.General_AgentCacheMode);
        Messages.get();
        this.agentCacheMode.add(Messages.General_Default);
        Messages.get();
        this.agentCacheMode.add(Messages.General_On);
        Messages.get();
        this.agentCacheMode.add(Messages.General_Off);
        this.agentCacheMode.select(this.dci.getCacheMode().getValue());
        this.multiplierDegree = new LabeledCombo(dialogArea, 0);
        this.multiplierDegree.setLabel("Multiplier degree");
        this.multiplierDegree.add("Fixed to P");
        this.multiplierDegree.add("Fixed to T");
        this.multiplierDegree.add("Fixed to G");
        this.multiplierDegree.add("Fixed to M");
        this.multiplierDegree.add("Fixed to K");
        this.multiplierDegree.add("Default");
        this.multiplierDegree.add("Fixed to m");
        this.multiplierDegree.add("Fixed to \u00ce\u00bc");
        this.multiplierDegree.add("Fixed to n");
        this.multiplierDegree.add("Fixed to p");
        this.multiplierDegree.add("Fixed to f");
        this.multiplierDegree.select(5 - this.dci.getMultiplier());
        this.relatedObject = new ObjectSelector(dialogArea, 0, true);
        this.relatedObject.setLabel("Related object");
        this.relatedObject.setObjectClass(GenericObject.class);
        this.relatedObject.setObjectId(this.dci.getRelatedObject());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.relatedObject.setLayoutData((Object)gd);
        this.interpretation = new LabeledCombo(dialogArea, 0);
        this.interpretation.setLabel("Interpretation");
        this.interpretation.add("Other");
        this.interpretation.add("Interface traffic - Inbound - bits/sec");
        this.interpretation.add("Interface traffic - Inbound - bytes/sec");
        this.interpretation.add("Interface traffic - Inbound - Utilization %");
        this.interpretation.add("Interface traffic - Outbound - bits/sec");
        this.interpretation.add("Interface traffic - Outbound - bytes/sec");
        this.interpretation.add("Interface traffic - Outbound - Utilization %");
        this.interpretation.add("Interface speed");
        this.interpretation.select(OtherOptions.interpretationFromTag(this.dci.getSystemTag()));
        return dialogArea;
    }

    protected void applyChanges(boolean isApply) {
        this.dci.setShowOnObjectTooltip(this.checkShowOnTooltip.getSelection());
        this.dci.setShowInObjectOverview(this.checkShowInOverview.getSelection());
        this.dci.setUsedForNodeStatusCalculation(this.checkCalculateStatus.getSelection());
        this.dci.setHideOnLastValuesView(this.checkHideOnLastValues.getSelection());
        this.dci.setCacheMode(AgentCacheMode.getByValue((int)this.agentCacheMode.getSelectionIndex()));
        this.dci.setMultiplier(5 - this.multiplierDegree.getSelectionIndex());
        this.dci.setRelatedObject(this.relatedObject.getObjectId());
        this.dci.setSystemTag(OtherOptions.tagFromInterpretation(this.interpretation.getSelectionIndex()));
        this.editor.modify();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.checkShowOnTooltip.setSelection(false);
        this.checkShowInOverview.setSelection(false);
        this.checkCalculateStatus.setSelection(false);
        this.checkHideOnLastValues.setSelection(false);
        this.agentCacheMode.select(0);
        this.multiplierDegree.select(0);
        this.relatedObject.setObjectId(0L);
        this.interpretation.select(0);
    }

    private static int interpretationFromTag(String tag) {
        if (tag == null || tag.isEmpty()) {
            return 0;
        }
        int i = 0;
        while (i < TAGS.length) {
            if (tag.equalsIgnoreCase(TAGS[i])) {
                return i + 1;
            }
            ++i;
        }
        return 0;
    }

    private static String tagFromInterpretation(int index) {
        return index > 0 && index <= TAGS.length ? TAGS[index - 1] : "";
    }
}

