/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.datacollection.widgets.LogParserEditor;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserModifyListener;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserType;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class WindowsEventParserConfigurator
extends ViewPart
implements ISaveablePart {
    public static final String ID = "org.netxms.ui.eclipse.serverconfig.views.WindowsEventParserConfigurator";
    private NXCSession session;
    private LogParserEditor editor;
    private boolean modified = false;
    private String content;
    private Action actionRefresh;
    private Action actionSave;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
    }

    public void createPartControl(Composite parent) {
        this.editor = new LogParserEditor(parent, 0, LogParserType.WIN_EVENT);
        this.editor.addModifyListener(new LogParserModifyListener(){

            public void modifyParser() {
                WindowsEventParserConfigurator.this.setModified(true);
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.refresh();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                WindowsEventParserConfigurator.this.refresh();
            }
        };
        this.actionSave = new Action("Save", SharedIcons.SAVE){

            public void run() {
                WindowsEventParserConfigurator.this.save();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    public void setFocus() {
        this.editor.setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
        this.editor.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                WindowsEventParserConfigurator.this.content = WindowsEventParserConfigurator.this.editor.getParserXml();
            }
        });
        try {
            this.session.setServerConfigClob("WindowsEventParser", this.content);
        }
        catch (Exception e) {
            MessageDialogHelper.openError((Shell)this.getSite().getShell(), (String)"Error", (String)String.format("Cannot save Windows event parser configuration: %s", e.getLocalizedMessage()));
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.modified;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.modified;
    }

    private void refresh() {
        if (this.modified && !MessageDialogHelper.openQuestion((Shell)this.getSite().getShell(), (String)"Confirm Refresh", (String)"This will destroy all unsaved changes. Are you sure?")) {
            return;
        }
        this.actionSave.setEnabled(false);
        new ConsoleJob("Load Windows even parser configuration", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                try {
                    WindowsEventParserConfigurator.this.content = WindowsEventParserConfigurator.this.session.getServerConfigClob("WindowsEventParser");
                }
                catch (NXCException e) {
                    if (e.getErrorCode() != 81) {
                        throw e;
                    }
                    WindowsEventParserConfigurator.this.content = "<parser>\n</parser>\n";
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).WindowsEventParserConfigurator.this.editor.setParserXml((this).WindowsEventParserConfigurator.this.content);
                        WindowsEventParserConfigurator.this.setModified(false);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot load Windows event parser configuration";
            }
        }.start();
    }

    private void save() {
        final String xml = this.editor.getParserXml();
        this.actionSave.setEnabled(false);
        new ConsoleJob("Save Windows event parser configuration", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                WindowsEventParserConfigurator.this.session.setServerConfigClob("WindowsEventParser", xml);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        WindowsEventParserConfigurator.this.setModified(false);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot save Windows event parser configuration";
            }
        }.start();
    }

    private void setModified(boolean b) {
        if (b != this.modified) {
            this.modified = b;
            this.firePropertyChange(257);
            this.actionSave.setEnabled(this.modified);
        }
    }

    public void dispose() {
        this.setModified(false);
        super.dispose();
    }
}

