/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.netxms.base.GeoLocation;
import org.netxms.base.NXCPMessage;
import org.netxms.base.NXCommon;
import org.netxms.base.PostalAddress;
import org.netxms.base.annotations.Internal;
import org.netxms.client.AccessListElement;
import org.netxms.client.ModuleDataProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.ObjectUrl;
import org.netxms.client.PollState;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.ObjectCategory;
import org.netxms.client.objects.configs.CustomAttribute;
import org.netxms.client.services.ServiceManager;
import org.netxms.client.users.ResponsibleUser;

public abstract class AbstractObject {
    public static final long NETWORK = 1L;
    public static final long SERVICEROOT = 2L;
    public static final long TEMPLATEROOT = 3L;
    public static final long ZONE0 = 4L;
    public static final long ASSETS = 5L;
    public static final long NETWORKMAPROOT = 6L;
    public static final long DASHBOARDROOT = 7L;
    public static final long BUSINESSSERVICEROOT = 9L;
    public static final long CONTEXT = 0xFFFFFFFFL;
    public static final int OBJECT_GENERIC = 0;
    public static final int OBJECT_SUBNET = 1;
    public static final int OBJECT_NODE = 2;
    public static final int OBJECT_INTERFACE = 3;
    public static final int OBJECT_NETWORK = 4;
    public static final int OBJECT_CONTAINER = 5;
    public static final int OBJECT_ZONE = 6;
    public static final int OBJECT_SERVICEROOT = 7;
    public static final int OBJECT_TEMPLATE = 8;
    public static final int OBJECT_TEMPLATEGROUP = 9;
    public static final int OBJECT_TEMPLATEROOT = 10;
    public static final int OBJECT_NETWORKSERVICE = 11;
    public static final int OBJECT_VPNCONNECTOR = 12;
    public static final int OBJECT_CONDITION = 13;
    public static final int OBJECT_CLUSTER = 14;
    public static final int OBJECT_BUSINESSSERVICEPROTOTYPE = 15;
    public static final int OBJECT_ASSET = 16;
    public static final int OBJECT_ASSETGROUP = 17;
    public static final int OBJECT_ASSETROOT = 18;
    public static final int OBJECT_NETWORKMAPROOT = 19;
    public static final int OBJECT_NETWORKMAPGROUP = 20;
    public static final int OBJECT_NETWORKMAP = 21;
    public static final int OBJECT_DASHBOARDROOT = 22;
    public static final int OBJECT_DASHBOARD = 23;
    public static final int OBJECT_BUSINESSSERVICEROOT = 27;
    public static final int OBJECT_BUSINESSSERVICE = 28;
    public static final int OBJECT_COLLECTOR = 29;
    public static final int OBJECT_MOBILEDEVICE = 31;
    public static final int OBJECT_RACK = 32;
    public static final int OBJECT_ACCESSPOINT = 33;
    public static final int OBJECT_WIRELESSDOMAIN = 34;
    public static final int OBJECT_CHASSIS = 35;
    public static final int OBJECT_DASHBOARDGROUP = 36;
    public static final int OBJECT_SENSOR = 37;
    public static final int OBJECT_CUSTOM = 10000;
    public static final int CALCULATE_DEFAULT = 0;
    public static final int CALCULATE_MOST_CRITICAL = 1;
    public static final int CALCULATE_SINGLE_THRESHOLD = 2;
    public static final int CALCULATE_MULTIPLE_THRESHOLDS = 3;
    public static final int PROPAGATE_DEFAULT = 0;
    public static final int PROPAGATE_UNCHANGED = 1;
    public static final int PROPAGATE_FIXED = 2;
    public static final int PROPAGATE_RELATIVE = 3;
    public static final int PROPAGATE_TRANSLATED = 4;
    @Internal
    protected NXCSession session = null;
    protected long objectId = 0L;
    protected UUID guid;
    protected String objectName;
    protected String alias;
    protected String nameOnMap;
    protected int objectClass;
    protected int categoryId;
    protected int flags;
    protected ObjectStatus status = ObjectStatus.UNKNOWN;
    protected boolean isDeleted = false;
    protected boolean inMaintenanceMode = false;
    protected int maintenanceInitiatorId = 0;
    protected long primaryZoneProxyId = 0L;
    protected long backupZoneProxyId = 0L;
    protected String comments;
    protected String commentsSource;
    protected GeoLocation geolocation;
    protected PostalAddress postalAddress;
    protected UUID mapImage;
    protected long drillDownObjectId;
    protected long assetId;
    protected final HashSet<Long> trustedObjects = new HashSet(0);
    protected boolean inheritAccessRights = true;
    protected HashSet<AccessListElement> accessList = new HashSet(0);
    protected int statusCalculationMethod;
    protected int statusPropagationMethod;
    protected ObjectStatus fixedPropagatedStatus;
    protected int statusShift;
    protected ObjectStatus[] statusTransformation;
    protected int statusSingleThreshold;
    protected int[] statusThresholds;
    protected Date creationTime;
    protected final HashSet<Long> parents = new HashSet(0);
    protected final HashSet<Long> children = new HashSet(0);
    protected final List<Long> dashboards = new ArrayList<Long>(0);
    protected final Map<String, CustomAttribute> customAttributes = new HashMap<String, CustomAttribute>(0);
    protected final List<ObjectUrl> urls = new ArrayList<ObjectUrl>(0);
    protected final List<ResponsibleUser> responsibleUsers = new ArrayList<ResponsibleUser>(0);
    protected Map<String, Object> moduleData = null;
    protected PollState[] pollStates = null;
    protected boolean partialObject;
    @Internal
    private int effectiveRights = 0;
    @Internal
    private boolean effectiveRightsCached = false;

    protected AbstractObject(long id, NXCSession session) {
        this.objectId = id;
        this.session = session;
        this.guid = UUID.randomUUID();
        this.objectName = "unknown";
        this.objectClass = 0;
        this.comments = "";
        this.commentsSource = "";
        this.geolocation = new GeoLocation(false);
        this.postalAddress = new PostalAddress();
        this.statusCalculationMethod = 0;
        this.statusPropagationMethod = 0;
        this.fixedPropagatedStatus = ObjectStatus.NORMAL;
        this.statusShift = 0;
        this.statusTransformation = new ObjectStatus[4];
        this.statusTransformation[0] = ObjectStatus.WARNING;
        this.statusTransformation[1] = ObjectStatus.MINOR;
        this.statusTransformation[2] = ObjectStatus.MAJOR;
        this.statusTransformation[3] = ObjectStatus.CRITICAL;
        this.statusSingleThreshold = 75;
        this.statusThresholds = new int[4];
        this.statusThresholds[0] = 75;
        this.statusThresholds[1] = 75;
        this.statusThresholds[2] = 75;
        this.statusThresholds[3] = 75;
        this.partialObject = false;
    }

    public AbstractObject(NXCPMessage msg, NXCSession session) {
        Long[] d;
        this.session = session;
        this.objectId = msg.getFieldAsInt32(3L);
        this.guid = msg.getFieldAsUUID(222L);
        this.objectName = msg.getFieldAsString(4L);
        this.alias = msg.getFieldAsString(494L);
        this.nameOnMap = msg.getFieldAsString(712L);
        this.objectClass = msg.getFieldAsInt32(5L);
        this.categoryId = msg.getFieldAsInt32(104L);
        this.flags = msg.getFieldAsInt32(13L);
        this.isDeleted = msg.getFieldAsBoolean(30L);
        this.status = ObjectStatus.getByValue(msg.getFieldAsInt32(10L));
        this.inMaintenanceMode = msg.getFieldAsBoolean(530L);
        this.maintenanceInitiatorId = msg.getFieldAsInt32(703L);
        this.primaryZoneProxyId = msg.getFieldAsInt64(638L);
        this.backupZoneProxyId = msg.getFieldAsInt64(639L);
        this.comments = msg.getFieldAsString(82L);
        this.commentsSource = msg.getFieldAsString(777L);
        this.geolocation = new GeoLocation(msg);
        this.postalAddress = new PostalAddress(msg);
        this.mapImage = msg.getFieldAsUUID(379L);
        this.drillDownObjectId = msg.getFieldAsInt64(389L);
        this.assetId = msg.getFieldAsInt64(827L);
        this.creationTime = msg.getFieldAsDate(240L);
        this.statusCalculationMethod = msg.getFieldAsInt32(160L);
        this.statusPropagationMethod = msg.getFieldAsInt32(183L);
        this.fixedPropagatedStatus = ObjectStatus.getByValue(msg.getFieldAsInt32(184L));
        this.statusShift = msg.getFieldAsInt32(185L);
        this.statusTransformation = new ObjectStatus[4];
        this.statusTransformation[0] = ObjectStatus.getByValue(msg.getFieldAsInt32(186L));
        this.statusTransformation[1] = ObjectStatus.getByValue(msg.getFieldAsInt32(187L));
        this.statusTransformation[2] = ObjectStatus.getByValue(msg.getFieldAsInt32(188L));
        this.statusTransformation[3] = ObjectStatus.getByValue(msg.getFieldAsInt32(189L));
        this.statusSingleThreshold = msg.getFieldAsInt32(190L);
        this.statusThresholds = new int[4];
        this.statusThresholds[0] = msg.getFieldAsInt32(191L);
        this.statusThresholds[1] = msg.getFieldAsInt32(192L);
        this.statusThresholds[2] = msg.getFieldAsInt32(193L);
        this.statusThresholds[3] = msg.getFieldAsInt32(194L);
        this.partialObject = msg.getFieldAsBoolean(595L);
        if (this.statusShift > Short.MAX_VALUE) {
            this.statusShift -= 65536;
        }
        int count = msg.getFieldAsInt32(7L);
        int i = 0;
        long id = 12288L;
        while (i < count) {
            this.parents.add(msg.getFieldAsInt64(id));
            ++i;
            ++id;
        }
        count = msg.getFieldAsInt32(31L);
        i = 0;
        id = 0x80000000L;
        while (i < count) {
            this.children.add(msg.getFieldAsInt64(id));
            ++i;
            ++id;
        }
        Long[] tobjects = msg.getFieldAsUInt32ArrayEx(307L);
        if (tobjects != null && tobjects.length > 0) {
            this.trustedObjects.addAll(Arrays.asList(tobjects));
        }
        if ((d = msg.getFieldAsUInt32ArrayEx(528L)) != null && d.length > 0) {
            this.dashboards.addAll(Arrays.asList(d));
        }
        count = msg.getFieldAsInt32(309L);
        i = 0;
        id = 0x70000000L;
        while (i < count) {
            this.customAttributes.put(msg.getFieldAsString(id), new CustomAttribute(msg, id + 1L));
            ++i;
            id += 4L;
        }
        count = msg.getFieldAsInt32(575L);
        i = 0;
        id = 0x74000000L;
        while (i < count) {
            this.urls.add(new ObjectUrl(msg, id));
            ++i;
            id += 10L;
        }
        this.inheritAccessRights = msg.getFieldAsBoolean(33L);
        count = msg.getFieldAsInt32(32L);
        i = 0;
        id = 4096L;
        long id2 = 8192L;
        while (i < count) {
            this.accessList.add(new AccessListElement(msg.getFieldAsInt32(id), msg.getFieldAsInt32(id2)));
            ++i;
            ++id;
            ++id2;
        }
        count = msg.getFieldAsInt32(476L);
        if (count > 0) {
            this.moduleData = new HashMap<String, Object>(count);
            i = 0;
            id = 0x71000000L;
            while (i < count) {
                String module = msg.getFieldAsString(id);
                ModuleDataProvider p = ServiceManager.getModuleDataProvider(module);
                if (p != null) {
                    this.moduleData.put(module, p.createModuleData(msg, id + 1L));
                }
                ++i;
                id += 0x100000L;
            }
        }
        count = msg.getFieldAsInt32(615L);
        id = 0x69000000L;
        i = 0;
        while (i < count) {
            this.responsibleUsers.add(new ResponsibleUser(msg, id));
            ++i;
            id += 10L;
        }
        count = msg.getFieldAsInt32(822L);
        if (count > 0) {
            id = 40960L;
            this.pollStates = new PollState[count];
            i = 0;
            while (i < count) {
                this.pollStates[i] = new PollState(msg, id);
                ++i;
                id += 10L;
            }
        }
    }

    public boolean isDefaultImage() {
        return this.mapImage == null || this.mapImage.equals(NXCommon.EMPTY_GUID);
    }

    public int getParentCount() {
        return this.parents.size();
    }

    public Iterator<Long> getParents() {
        return this.parents.iterator();
    }

    public Iterator<Long> getChildren() {
        return this.children.iterator();
    }

    public AccessListElement[] getAccessList() {
        return this.accessList.toArray(new AccessListElement[this.accessList.size()]);
    }

    public List<ObjectUrl> getUrls() {
        return new ArrayList<ObjectUrl>(this.urls);
    }

    public boolean hasUrls() {
        return !this.urls.isEmpty();
    }

    public String getCommentsSource() {
        return this.commentsSource;
    }

    public String getComments() {
        return this.comments;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getObjectNameWithPath() {
        List<AbstractObject> parents = this.getParentChain(null);
        Collections.reverse(parents);
        StringBuilder sb = new StringBuilder();
        for (AbstractObject parent : parents) {
            sb.append(parent.getObjectName());
            sb.append("/");
        }
        sb.append(this.getObjectName());
        return sb.toString();
    }

    public String getAlias() {
        return this.alias != null ? this.alias : "";
    }

    public String getNameOnMap() {
        return this.nameOnMap != null && !this.nameOnMap.isEmpty() ? this.nameOnMap : this.objectName;
    }

    public String getConfiguredNameOnMap() {
        return this.nameOnMap != null ? this.nameOnMap : "";
    }

    public String getNameWithAlias() {
        return this.alias == null || this.alias.isEmpty() ? this.objectName : String.valueOf(this.objectName) + " (" + this.alias + ")";
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public ObjectCategory getCategory() {
        return this.categoryId != 0 ? this.session.getObjectCategory(this.categoryId) : null;
    }

    public ObjectStatus getStatus() {
        return this.status;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public boolean isInheritAccessRights() {
        return this.inheritAccessRights;
    }

    public boolean isChildOf(long objectId) {
        if (this.parents.contains(objectId)) {
            return true;
        }
        for (Long id : this.parents) {
            AbstractObject object = this.session.findObjectById(id);
            if (object == null || !object.isChildOf(objectId)) continue;
            return true;
        }
        return false;
    }

    public boolean isChildOf(long[] objects) {
        long[] lArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            long object = lArray[n2];
            if (this.isChildOf(object)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isDirectChildOf(long objectId) {
        return this.parents.contains(objectId);
    }

    public boolean isParentOf(long objectId) {
        if (this.children.contains(objectId)) {
            return true;
        }
        for (Long id : this.children) {
            AbstractObject object = this.session.findObjectById(id);
            if (object == null || !object.isParentOf(objectId)) continue;
            return true;
        }
        return false;
    }

    public boolean isParentOf(long[] objects) {
        long[] lArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            long object = lArray[n2];
            if (this.isParentOf(object)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isDirectParentOf(long objectId) {
        return this.children.contains(objectId);
    }

    public AbstractObject[] getParentsAsArray() {
        ArrayList<AbstractObject> list = new ArrayList<AbstractObject>(this.parents.size());
        for (Long parent : this.parents) {
            AbstractObject obj = this.session.findObjectById(parent);
            if (obj == null) continue;
            list.add(obj);
        }
        return list.toArray(new AbstractObject[list.size()]);
    }

    public AbstractObject[] getChildrenAsArray() {
        ArrayList<AbstractObject> list = new ArrayList<AbstractObject>(this.children.size());
        for (Long id : this.children) {
            AbstractObject obj = this.session.findObjectById(id);
            if (obj == null) continue;
            list.add(obj);
        }
        return list.toArray(new AbstractObject[list.size()]);
    }

    public long[] getChildIdList() {
        long[] list = new long[this.children.size()];
        int i = 0;
        for (Long id : this.children) {
            list[i++] = id;
        }
        return list;
    }

    public long[] getParentIdList() {
        long[] list = new long[this.parents.size()];
        int i = 0;
        for (Long id : this.parents) {
            list[i++] = id;
        }
        return list;
    }

    private void getAllChildrenInternal(int[] classFilter, Set<AbstractObject> set) {
        for (Long child : this.children) {
            AbstractObject obj = this.session.findObjectById(child);
            if (obj == null) continue;
            if (this.matchClassFilter(classFilter, obj.getObjectClass())) {
                set.add(obj);
            }
            obj.getAllChildrenInternal(classFilter, set);
        }
    }

    public int getChildCount() {
        return this.children.size();
    }

    private boolean matchClassFilter(int[] classFilter, int objectClass) {
        if (classFilter == null) {
            return true;
        }
        int[] nArray = classFilter;
        int n = classFilter.length;
        int n2 = 0;
        while (n2 < n) {
            int c = nArray[n2];
            if (objectClass == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Set<AbstractObject> getAllChildren(int classFilter) {
        int[] nArray;
        HashSet<AbstractObject> result = new HashSet<AbstractObject>();
        if (classFilter < 0) {
            nArray = null;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = classFilter;
        }
        this.getAllChildrenInternal(nArray, result);
        return result;
    }

    public Set<AbstractObject> getAllChildren(int[] classFilter) {
        HashSet<AbstractObject> result = new HashSet<AbstractObject>();
        this.getAllChildrenInternal(classFilter, result);
        return result;
    }

    private void getAllParentsInternal(int[] classFilter, Collection<AbstractObject> result, boolean chain) {
        for (Long parent : this.parents) {
            AbstractObject obj = this.session.findObjectById(parent);
            if (obj == null) continue;
            if (this.matchClassFilter(classFilter, obj.getObjectClass())) {
                result.add(obj);
                obj.getAllParentsInternal(classFilter, result, chain);
                if (!chain) continue;
                break;
            }
            obj.getAllParentsInternal(classFilter, result, chain);
        }
    }

    public Set<AbstractObject> getAllParents(int classFilter) {
        int[] nArray;
        HashSet<AbstractObject> result = new HashSet<AbstractObject>();
        if (classFilter < 0) {
            nArray = null;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = classFilter;
        }
        this.getAllParentsInternal(nArray, result, false);
        return result;
    }

    public Set<AbstractObject> getAllParents(int[] classFilter) {
        HashSet<AbstractObject> result = new HashSet<AbstractObject>();
        this.getAllParentsInternal(classFilter, result, false);
        return result;
    }

    public List<AbstractObject> getParentChain(int[] classFilter) {
        ArrayList<AbstractObject> chain = new ArrayList<AbstractObject>();
        this.getAllParentsInternal(classFilter, chain, true);
        return chain;
    }

    public List<AbstractObject> getTrustedObjects() {
        return this.session.findMultipleObjects(this.trustedObjects, true);
    }

    public List<AbstractObject> getDashboards(boolean accessibleOnly) {
        return this.session.findMultipleObjects(this.dashboards, !accessibleOnly);
    }

    public boolean hasDashboard(long dashboardId) {
        return this.dashboards.contains(dashboardId);
    }

    public boolean hasParents() {
        return this.parents.size() > 0;
    }

    public boolean hasAccessibleParents(Set<Integer> classFilter) {
        for (Long id : this.parents) {
            AbstractObject p = this.session.findObjectById(id);
            if (p == null || classFilter != null && !classFilter.contains(p.getObjectClass())) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public boolean hasAccessibleChildren() {
        for (Long id : this.children) {
            if (this.session.findObjectById(id) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowedOnMap() {
        return false;
    }

    public boolean isAlarmsVisible() {
        return false;
    }

    public int getObjectClass() {
        return this.objectClass;
    }

    public String getObjectClassName() {
        return "Class " + Integer.toString(this.objectClass);
    }

    public Map<String, CustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public CustomAttribute getCustomAttribute(String name) {
        return this.customAttributes.get(name);
    }

    public String getCustomAttributeValue(String name) {
        CustomAttribute a = this.customAttributes.get(name);
        return a != null ? a.getValue() : null;
    }

    public boolean getCustomAttributeValueAsBoolean(String name) {
        CustomAttribute a = this.customAttributes.get(name);
        if (a == null) {
            return false;
        }
        try {
            return Integer.parseInt(a.getValue()) != 0;
        }
        catch (NumberFormatException numberFormatException) {
            return Boolean.parseBoolean(a.getValue());
        }
    }

    public boolean hasCustomAttribute(String name) {
        return this.customAttributes.containsKey(name);
    }

    public GeoLocation getGeolocation() {
        return this.geolocation;
    }

    public int hashCode() {
        return (int)this.objectId;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public UUID getMapImage() {
        ObjectCategory category;
        if (this.mapImage != null && !this.mapImage.equals(NXCommon.EMPTY_GUID)) {
            return this.mapImage;
        }
        if (this.categoryId != 0 && (category = this.session.getObjectCategory(this.categoryId)) != null) {
            return category.getMapImage();
        }
        return null;
    }

    public UUID getIcon() {
        ObjectCategory category;
        if (this.categoryId != 0 && (category = this.session.getObjectCategory(this.categoryId)) != null) {
            return category.getIcon();
        }
        return null;
    }

    public long getDrillDownObjectId() {
        return this.drillDownObjectId;
    }

    public long getAssetId() {
        return this.assetId;
    }

    public int getStatusCalculationMethod() {
        return this.statusCalculationMethod;
    }

    public int getStatusPropagationMethod() {
        return this.statusPropagationMethod;
    }

    public ObjectStatus getFixedPropagatedStatus() {
        return this.fixedPropagatedStatus;
    }

    public int getStatusShift() {
        return this.statusShift;
    }

    public ObjectStatus[] getStatusTransformation() {
        return this.statusTransformation;
    }

    public int getStatusSingleThreshold() {
        return this.statusSingleThreshold;
    }

    public int[] getStatusThresholds() {
        return this.statusThresholds;
    }

    public final void setSession(NXCSession session) {
        this.session = session;
    }

    public int getEffectiveRights() {
        if (this.effectiveRightsCached) {
            return this.effectiveRights;
        }
        try {
            this.effectiveRights = this.session.getEffectiveRights(this.objectId);
            this.effectiveRightsCached = true;
        }
        catch (Exception e) {
            this.effectiveRights = 0;
        }
        return this.effectiveRights;
    }

    public Object getModuleData(String module) {
        return this.moduleData != null ? this.moduleData.get(module) : null;
    }

    public PostalAddress getPostalAddress() {
        return this.postalAddress;
    }

    public boolean isInMaintenanceMode() {
        return this.inMaintenanceMode;
    }

    public int getMaintenanceInitiatorId() {
        return this.maintenanceInitiatorId;
    }

    public long getPrimaryZoneProxyId() {
        return this.primaryZoneProxyId;
    }

    public long getBackupZoneProxyId() {
        return this.backupZoneProxyId;
    }

    protected static void addString(Set<String> strings, String s) {
        if (s == null) {
            return;
        }
        String ts = s.trim();
        if (!ts.isEmpty()) {
            strings.add(ts);
        }
    }

    public Set<String> getStrings() {
        HashSet<String> strings = new HashSet<String>();
        AbstractObject.addString(strings, this.comments);
        AbstractObject.addString(strings, this.objectName);
        AbstractObject.addString(strings, this.alias);
        if (this.postalAddress != null && !this.postalAddress.isEmpty()) {
            strings.add(this.postalAddress.getAddressLine());
        }
        for (CustomAttribute s : this.customAttributes.values()) {
            AbstractObject.addString(strings, s.getValue());
        }
        for (ObjectUrl u : this.urls) {
            AbstractObject.addString(strings, u.getUrl().toString());
            AbstractObject.addString(strings, u.getDescription());
        }
        return strings;
    }

    public List<ResponsibleUser> getResponsibleUsers() {
        return this.responsibleUsers;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public boolean areChildrenSynchronized() {
        return this.session.areChildrenSynchronized(this.objectId);
    }

    public boolean isPartialObject() {
        return this.partialObject;
    }
}

