/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import java.text.DateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import org.netxms.base.NXCPMessage;
import org.netxms.client.ClientLocalizationHelper;
import org.netxms.client.events.TimeFrameFormatException;

public class TimeFrame {
    public static final String[] DAYS_OF_THE_WEEK = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
    public static final String[] MONTHS = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private long daysConfiguration;
    private int startMinute;
    private int startHour;
    private int endMinute;
    private int endHour;
    private String daysOfMonth;
    private boolean[] daysOfWeek;
    private boolean[] months;

    public TimeFrame() {
        this.startMinute = 0;
        this.startHour = 0;
        this.endMinute = 23;
        this.endHour = 59;
        this.daysOfMonth = new String("1-31");
        this.daysOfWeek = new boolean[7];
        this.months = new boolean[12];
        this.daysConfiguration = 0L;
    }

    public TimeFrame(int time, long date) {
        this.daysConfiguration = date;
        this.startHour = time / 1000000;
        this.startMinute = time / 10000 % 100;
        this.endHour = time % 10000 / 100;
        this.endMinute = time % 100;
        StringBuilder days = new StringBuilder();
        int state = 0;
        boolean isLastDay = (date & 1L) == 1L;
        date >>= 1;
        int i = 0;
        while (i < 31) {
            switch (state) {
                case 0: {
                    if ((date & 1L) != 1L) break;
                    if (days.length() != 0) {
                        days.append(", ");
                    }
                    days.append(i + 1);
                    state = 1;
                    break;
                }
                case 1: {
                    if ((date & 1L) == 1L && (date & 2L) == 2L) {
                        state = 2;
                        days.append("-");
                        break;
                    }
                    if ((date & 1L) == 1L) {
                        days.append(", ");
                        days.append(i + 1);
                        break;
                    }
                    state = 0;
                    break;
                }
                case 2: {
                    if ((date & 1L) != 1L || (date & 2L) != 0L && i != 30) break;
                    state = 0;
                    days.append(i + 1);
                }
            }
            date >>= 1;
            ++i;
        }
        if (isLastDay) {
            if (days.length() != 0) {
                days.append(", ");
            }
            days.append("L");
        }
        this.daysOfMonth = days.toString();
        this.daysOfWeek = new boolean[7];
        i = 0;
        while (i < 7) {
            this.daysOfWeek[i] = (date & 1L) == 1L;
            date >>= 1;
            ++i;
        }
        this.months = new boolean[12];
        i = 0;
        while (i < 12) {
            this.months[i] = (date & 1L) == 1L;
            date >>= 1;
            ++i;
        }
    }

    public TimeFrame(TimeFrame src) {
        this.startMinute = src.startMinute;
        this.startHour = src.startHour;
        this.endMinute = src.endMinute;
        this.endHour = src.endHour;
        this.daysOfMonth = src.daysOfMonth;
        this.daysOfWeek = Arrays.copyOf(src.daysOfWeek, src.daysOfWeek.length);
        this.months = Arrays.copyOf(src.months, src.months.length);
        this.daysConfiguration = src.daysConfiguration;
    }

    public String getFormattedDateString(DateFormat dfTime, Locale locale) {
        if (this.isNever()) {
            return ClientLocalizationHelper.getText("TimeFrame_Never", locale);
        }
        StringBuilder sb = new StringBuilder();
        if (this.isAnyTime()) {
            sb.append(ClientLocalizationHelper.getText("TimeFrame_AnyTime", locale));
        } else {
            Calendar from = Calendar.getInstance();
            from.set(12, this.getStartMinute());
            from.set(11, this.getStartHour());
            from.set(13, 0);
            Calendar to = Calendar.getInstance();
            to.set(12, this.getEndMinute());
            to.set(11, this.getEndHour());
            to.set(13, 0);
            sb.append(String.format(ClientLocalizationHelper.getText("TimeFrame_TimeFormat", locale), dfTime.format(from.getTime()), dfTime.format(to.getTime())));
        }
        if (this.isAnyDay()) {
            sb.append(ClientLocalizationHelper.getText("TimeFrame_AnyDay", locale));
        } else {
            sb.append(String.format(ClientLocalizationHelper.getText("TimeFrame_DayFormat", locale), this.getDaysOfMonth(), this.buildIntervals(this.daysOfWeek, DAYS_OF_THE_WEEK, locale), this.buildIntervals(this.months, MONTHS, locale)));
        }
        return sb.toString();
    }

    private String buildIntervals(boolean[] bits, String[] options, Locale locale) {
        StringBuilder text = new StringBuilder();
        int state = 0;
        int i = 0;
        while (i < bits.length) {
            switch (state) {
                case 0: {
                    if (!bits[i]) break;
                    if (text.length() != 0) {
                        text.append(", ");
                    }
                    text.append(ClientLocalizationHelper.getText(options[i], locale));
                    state = 1;
                    break;
                }
                case 1: {
                    if (bits[i] && i + 1 != bits.length && bits[i + 1]) {
                        state = 2;
                        text.append("-");
                        break;
                    }
                    if (bits[i]) {
                        text.append(", ");
                        text.append(ClientLocalizationHelper.getText(options[i], locale));
                        break;
                    }
                    state = 0;
                    break;
                }
                case 2: {
                    if (!bits[i] || i + 1 != bits.length && bits[i + 1]) break;
                    state = 0;
                    text.append(ClientLocalizationHelper.getText(options[i], locale));
                }
            }
            ++i;
        }
        return text.toString();
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        int time = this.startHour * 1000000 + this.startMinute * 10000 + this.endHour * 100 + this.endMinute;
        msg.setFieldInt32(baseId++, time);
        msg.setFieldInt64(baseId++, this.daysConfiguration);
    }

    public int getStartMinute() {
        return this.startMinute;
    }

    public int getStartHour() {
        return this.startHour;
    }

    public int getEndMinute() {
        return this.endMinute;
    }

    public int getEndHour() {
        return this.endHour;
    }

    public String getDaysOfMonth() {
        return this.daysOfMonth;
    }

    public boolean[] getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public boolean[] getMonths() {
        return this.months;
    }

    public long getDaysConfiguration() {
        return this.daysConfiguration;
    }

    public void update(int startHour, int startMinute, int endHour, int endMinute, boolean[] daysOfWeek, String daysOfMonth, boolean[] months) throws TimeFrameFormatException {
        int startTime = startHour * 100 + startMinute;
        int endTime = endHour * 100 + endMinute;
        if (startHour < 0 || startHour > 23 || endHour < 0 || endHour > 23 || startMinute < 0 || startMinute > 59 || endMinute < 0 || endMinute > 59) {
            throw new TimeFrameFormatException(1);
        }
        if (startTime > endTime) {
            throw new TimeFrameFormatException(2);
        }
        long date = 0L;
        int i = 11;
        while (i >= 0) {
            if (months[i]) {
                ++date;
            }
            date <<= 1;
            --i;
        }
        i = 6;
        while (i >= 0) {
            if (daysOfWeek[i]) {
                ++date;
            }
            date <<= 1;
            --i;
        }
        date <<= 31;
        if (daysOfMonth.isEmpty()) {
            date |= 0xFFFFFFFFFFFFFFFFL;
        } else {
            String[] entries;
            String[] stringArray = entries = daysOfMonth.split(",");
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                block19: {
                    String entry = stringArray[n2];
                    if (entry.contains("-")) {
                        String[] ranges = entry.split("-");
                        try {
                            int start = Integer.parseInt(ranges[0].trim());
                            int end = Integer.parseInt(ranges[1].trim());
                            if (start >= 1 && end <= 31) {
                                while (start <= end) {
                                    date |= 1L << start;
                                    ++start;
                                }
                                break block19;
                            }
                            throw new TimeFrameFormatException(3);
                        }
                        catch (Exception e) {
                            throw new TimeFrameFormatException(4);
                        }
                    }
                    if (entry.equalsIgnoreCase("L")) {
                        date |= 1L;
                    } else {
                        try {
                            int num = Integer.parseInt(entry.trim());
                            if (num >= 1 && num <= 31) {
                                date |= 1L << num;
                                break block19;
                            }
                            throw new TimeFrameFormatException(3);
                        }
                        catch (Exception e) {
                            throw new TimeFrameFormatException(4);
                        }
                    }
                }
                ++n2;
            }
        }
        this.startHour = startHour;
        this.startMinute = startMinute;
        this.endHour = endHour;
        this.endMinute = endMinute;
        this.daysOfMonth = daysOfMonth;
        this.daysOfWeek = daysOfWeek;
        this.months = months;
        this.daysConfiguration = date;
    }

    public boolean isAnyDay() {
        return this.daysConfiguration == 0x7FFFFFFFFFFFFL || this.daysConfiguration == 0x7FFFFFFFFFFFEL;
    }

    public boolean isAnyTime() {
        return this.startHour == 0 && this.startMinute == 0 && this.endHour == 23 && this.endMinute == 59;
    }

    public boolean isNever() {
        return (this.daysConfiguration & 0xFFFFFFFFL) == 0L || (this.daysConfiguration & 0x7F00000000L) == 0L || (this.daysConfiguration & 0x7FF8000000000L) == 0L;
    }
}

