/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.maps.configs.SingleDciConfig;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Dashboard;
import org.netxms.client.objects.NetworkMap;
import org.netxms.client.xml.XMLTools;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.dashboard.Activator;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.StatusIndicatorConfig;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.ViewRefreshController;

public class StatusIndicatorElement
extends ElementWidget {
    private NXCSession session = ConsoleSharedData.getSession();
    private StatusIndicatorConfig config;
    private ViewRefreshController refreshController;
    private boolean requireScriptRun = false;
    private boolean requireDataCollection = false;
    private StatusIndicatorElementWidget[] elementWidgets;
    private static final int ELEMENT_HEIGHT = 36;

    protected StatusIndicatorElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.config = (StatusIndicatorConfig)XMLTools.createFromXml(StatusIndicatorConfig.class, (String)element.getData());
        }
        catch (Exception e) {
            Activator.logError("Cannot parse dashboard element configuration", e);
            this.config = new StatusIndicatorConfig();
        }
        this.processCommonSettings(this.config);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 16;
        layout.marginWidth = 16;
        layout.verticalSpacing = 16;
        layout.horizontalSpacing = 16;
        layout.numColumns = this.config.getNumColumns();
        layout.makeColumnsEqualWidth = true;
        this.getContentArea().setLayout((Layout)layout);
        this.elementWidgets = new StatusIndicatorElementWidget[this.config.getElements().length];
        int i = 0;
        while (i < this.elementWidgets.length) {
            StatusIndicatorConfig.StatusIndicatorElementConfig e = this.config.getElements()[i];
            if (e.getType() == 3) {
                this.requireScriptRun = true;
            } else if (e.getType() == 1 || e.getType() == 2) {
                this.requireDataCollection = true;
            }
            this.elementWidgets[i] = new StatusIndicatorElementWidget(this.getContentArea(), e);
            this.elementWidgets[i].setLayoutData(new GridData(4, 4, true, false));
            ++i;
        }
        ConsoleJob job = new ConsoleJob("Synchronize objects", (IWorkbenchPart)viewPart, "org.netxms.ui.eclipse.dashboard"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ArrayList<Long> relatedObjects = new ArrayList<Long>();
                StatusIndicatorConfig.StatusIndicatorElementConfig[] statusIndicatorElementConfigArray = StatusIndicatorElement.this.config.getElements();
                int n = statusIndicatorElementConfigArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StatusIndicatorConfig.StatusIndicatorElementConfig e = statusIndicatorElementConfigArray[n2];
                    if (e.getType() == 0) {
                        relatedObjects.add(StatusIndicatorElement.this.getEffectiveObjectId(e.getObjectId()));
                    }
                    ++n2;
                }
                if (!relatedObjects.isEmpty()) {
                    StatusIndicatorElement.this.session.syncMissingObjects(relatedObjects, 2);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (!StatusIndicatorElement.this.isDisposed()) {
                                StatusIndicatorElement.this.refreshData();
                            }
                        }
                    });
                }
                DciValue[] nodeDciList = null;
                int i = 0;
                while (i < StatusIndicatorElement.this.elementWidgets.length) {
                    StatusIndicatorConfig.StatusIndicatorElementConfig e = StatusIndicatorElement.this.config.getElements()[i];
                    if (e.getType() == 2) {
                        AbstractObject contextObject = StatusIndicatorElement.this.getContext();
                        if (contextObject == null) break;
                        if (nodeDciList == null) {
                            nodeDciList = StatusIndicatorElement.this.session.getLastValues(contextObject.getObjectId());
                        }
                        Pattern namePattern = !e.getDciName().isEmpty() ? Pattern.compile(e.getDciName()) : null;
                        Pattern descriptionPattern = !e.getDciDescription().isEmpty() ? Pattern.compile(e.getDciDescription()) : null;
                        DciValue[] dciValueArray = nodeDciList;
                        int n3 = nodeDciList.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            DciValue dciInfo = dciValueArray[n4];
                            if (namePattern != null && namePattern.matcher(dciInfo.getName()).find() || descriptionPattern != null && descriptionPattern.matcher(dciInfo.getDescription()).find()) {
                                e.setObjectId(contextObject.getObjectId());
                                e.setDciId(dciInfo.getId());
                                break;
                            }
                            ++n4;
                        }
                    }
                    ++i;
                }
            }

            protected String getErrorMessage() {
                return "Cannot synchronize objects";
            }
        };
        job.setUser(false);
        job.start();
        this.startRefreshTimer();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StatusIndicatorElement.this.refreshController.dispose();
            }
        });
    }

    private void refreshData() {
        if (this.requireDataCollection || this.requireScriptRun) {
            ConsoleJob job = new ConsoleJob("Update status indicator", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.dashboard"){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    DciValue[] dciValues;
                    Map scriptData;
                    if (StatusIndicatorElement.this.requireScriptRun) {
                        long contextObjectId = StatusIndicatorElement.this.config.getScriptContextObjectId();
                        if (contextObjectId == 0L) {
                            contextObjectId = StatusIndicatorElement.this.getDashboardObjectId();
                        } else if (contextObjectId == 0xFFFFFFFFL) {
                            contextObjectId = StatusIndicatorElement.this.getContextObjectId();
                        }
                        scriptData = StatusIndicatorElement.this.session.queryScript(contextObjectId, StatusIndicatorElement.this.config.getScript(), null, null);
                    } else {
                        scriptData = null;
                    }
                    if (StatusIndicatorElement.this.requireDataCollection) {
                        ArrayList<SingleDciConfig> dciList = new ArrayList<SingleDciConfig>();
                        int i = 0;
                        while (i < StatusIndicatorElement.this.config.getElements().length) {
                            StatusIndicatorConfig.StatusIndicatorElementConfig e = StatusIndicatorElement.this.config.getElements()[i];
                            if ((e.getType() == 1 || e.getType() == 2) && e.getDciId() != 0L) {
                                dciList.add(new SingleDciConfig(e.getObjectId(), e.getDciId()));
                            }
                            ++i;
                        }
                        dciValues = !dciList.isEmpty() ? StatusIndicatorElement.this.session.getLastValues(dciList) : null;
                    } else {
                        dciValues = null;
                    }
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (!StatusIndicatorElement.this.isDisposed()) {
                                StatusIndicatorElement.this.updateElements(scriptData, dciValues);
                            }
                        }
                    });
                }

                protected String getErrorMessage() {
                    return "Error updating status indicator";
                }
            };
            job.setUser(false);
            job.start();
        } else {
            this.updateElements(null, null);
        }
    }

    private void updateElements(Map<String, String> scriptData, DciValue[] dciValues) {
        StatusIndicatorElementWidget[] statusIndicatorElementWidgetArray = this.elementWidgets;
        int n = this.elementWidgets.length;
        int n2 = 0;
        while (n2 < n) {
            StatusIndicatorElementWidget w = statusIndicatorElementWidgetArray[n2];
            StatusIndicatorConfig.StatusIndicatorElementConfig e = w.getElementConfig();
            switch (e.getType()) {
                case 0: {
                    AbstractObject object = this.session.findObjectById(this.getEffectiveObjectId(e.getObjectId()));
                    w.setStatus(object != null ? object.getStatus() : ObjectStatus.UNKNOWN);
                    break;
                }
                case 3: {
                    String value = scriptData.get(e.getTag());
                    if (value != null) {
                        try {
                            w.setStatus(ObjectStatus.getByValue((int)Integer.parseInt(value)));
                        }
                        catch (NumberFormatException ex) {
                            w.setStatus(ObjectStatus.UNKNOWN);
                        }
                        break;
                    }
                    w.setStatus(ObjectStatus.UNKNOWN);
                    break;
                }
                case 1: 
                case 2: {
                    boolean found = false;
                    if (dciValues != null) {
                        DciValue[] dciValueArray = dciValues;
                        int n3 = dciValues.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            DciValue v = dciValueArray[n4];
                            if (v.getId() == e.getDciId()) {
                                Threshold t = v.getActiveThreshold();
                                w.setStatus(t != null ? ObjectStatus.getByValue((int)t.getCurrentSeverity().getValue()) : ObjectStatus.NORMAL);
                                found = true;
                                break;
                            }
                            ++n4;
                        }
                    }
                    if (found) break;
                    w.setStatus(ObjectStatus.UNKNOWN);
                }
            }
            ++n2;
        }
    }

    protected void startRefreshTimer() {
        this.refreshController = new ViewRefreshController(this.viewPart, 15, new Runnable(){

            @Override
            public void run() {
                if (StatusIndicatorElement.this.isDisposed()) {
                    return;
                }
                StatusIndicatorElement.this.refreshData();
            }
        });
        this.refreshData();
    }

    private class StatusIndicatorElementWidget
    extends Canvas {
        private StatusIndicatorConfig.StatusIndicatorElementConfig elementConfig;
        private ObjectStatus status;

        StatusIndicatorElementWidget(Composite parent, StatusIndicatorConfig.StatusIndicatorElementConfig elementConfig) {
            super(parent, 0);
            this.elementConfig = elementConfig;
            this.status = ObjectStatus.UNKNOWN;
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    StatusIndicatorElementWidget.this.drawContent(e.gc);
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    StatusIndicatorElementWidget.this.openDrillDownObject();
                }
            });
        }

        private void drawContent(GC gc) {
            Rectangle indicatorRect;
            gc.setAntialias(1);
            if (StatusIndicatorElement.this.config.isFullColorRange()) {
                gc.setBackground(StatusDisplayInfo.getStatusColor((ObjectStatus)this.status));
            } else {
                gc.setBackground(this.status == ObjectStatus.NORMAL ? StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.NORMAL) : StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.CRITICAL));
            }
            Rectangle clientArea = this.getClientArea();
            switch (StatusIndicatorElement.this.config.getLabelType()) {
                case 1: {
                    indicatorRect = new Rectangle(0, (clientArea.height - 36) / 2, clientArea.width, 36);
                    break;
                }
                case 2: {
                    indicatorRect = new Rectangle(0, (clientArea.height - 36) / 2, 36, 36);
                    break;
                }
                case 0: {
                    indicatorRect = new Rectangle((clientArea.width - 36) / 2, (clientArea.height - 36) / 2, 36, 36);
                    break;
                }
                default: {
                    return;
                }
            }
            switch (StatusIndicatorElement.this.config.getShape()) {
                case 0: {
                    gc.fillOval(indicatorRect.x, indicatorRect.y, indicatorRect.width, indicatorRect.height);
                    break;
                }
                case 1: {
                    gc.fillRectangle(indicatorRect);
                    break;
                }
                case 2: {
                    gc.fillRoundRectangle(indicatorRect.x, indicatorRect.y, indicatorRect.width, indicatorRect.height, 8, 8);
                }
            }
            if (StatusIndicatorElement.this.config.getLabelType() != 0) {
                gc.setFont(JFaceResources.getBannerFont());
                String label = this.elementConfig.getLabel();
                if ((label == null || label.isEmpty()) && this.elementConfig.getType() == 0) {
                    label = StatusIndicatorElement.this.session.getObjectName(StatusIndicatorElement.this.getEffectiveObjectId(this.elementConfig.getObjectId()));
                    this.elementConfig.setLabel(label);
                }
                Point textExtent = gc.textExtent(label);
                if (StatusIndicatorElement.this.config.getLabelType() == 1) {
                    gc.setForeground(this.getDisplay().getSystemColor(ColorConverter.isDarkColor((Color)gc.getBackground()) ? 15 : 2));
                    gc.drawText(this.elementConfig.getLabel(), (clientArea.width - textExtent.x) / 2, (clientArea.height - textExtent.y) / 2);
                } else {
                    gc.setBackground(this.getBackground());
                    gc.drawText(this.elementConfig.getLabel(), 40, (clientArea.height - textExtent.y) / 2);
                }
            }
        }

        void openDrillDownObject() {
            AbstractObject object = StatusIndicatorElement.this.session.findObjectById(this.elementConfig.getDrilldownObjectId());
            if (object == null || !(object instanceof Dashboard) && !(object instanceof NetworkMap)) {
                return;
            }
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            try {
                window.getActivePage().showView(object instanceof Dashboard ? "org.netxms.ui.eclipse.dashboard.views.DashboardView" : "org.netxms.ui.eclipse.networkmaps.views.PredefinedMap", Long.toString(object.getObjectId()), 1);
            }
            catch (PartInitException e) {
                MessageDialogHelper.openError((Shell)window.getShell(), (String)"Error", (String)String.format("Cannot open %s view \"%s\" (%s)", object instanceof Dashboard ? "dashboard" : "network map", object.getObjectName(), e.getMessage()));
            }
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            return new Point(wHint == -1 ? 36 : wHint, 36);
        }

        public StatusIndicatorConfig.StatusIndicatorElementConfig getElementConfig() {
            return this.elementConfig;
        }

        public void setStatus(ObjectStatus status) {
            if (this.status != status) {
                this.status = status;
                this.redraw();
            }
        }
    }
}

