/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.dialogs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.NotificationChannel;
import org.netxms.client.users.TwoFactorAuthenticationMethod;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class TwoFactorAuthMethodEditDialog
extends Dialog {
    private static final Logger logger = LoggerFactory.getLogger(TwoFactorAuthMethodEditDialog.class);
    private final I18n i18n = LocalizationHelper.getI18n(TwoFactorAuthMethodEditDialog.class);
    private TwoFactorAuthenticationMethod method;
    private LabeledText textName;
    private LabeledText textDescription;
    private Combo comboDriverName;
    private Composite driverConfigurationArea;
    private Combo comboChannelName;
    private boolean isNameChanged;
    private String newName;
    private Properties driverConfiguration = new Properties();
    private List<NotificationChannel> notificationChannels = null;

    public TwoFactorAuthMethodEditDialog(Shell parentShell, TwoFactorAuthenticationMethod method) {
        super(parentShell);
        this.method = method;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.method != null ? this.i18n.tr("Edit Method") : this.i18n.tr("Create Method"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.textName = new LabeledText(dialogArea, 0);
        this.textName.setLabel(this.i18n.tr("Name"));
        this.textName.getTextControl().setTextLimit(63);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.textName.setLayoutData((Object)gd);
        this.textDescription = new LabeledText(dialogArea, 0);
        this.textDescription.setLabel(this.i18n.tr("Description"));
        this.textDescription.getTextControl().setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textDescription.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.comboDriverName = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)this.i18n.tr("Driver"), (Object)gd);
        this.comboDriverName.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.method != null) {
            this.textName.setText(this.method.getName());
            this.textDescription.setText(this.method.getDescription());
            try (ByteArrayInputStream in = new ByteArrayInputStream(this.method.getConfiguration().getBytes("UTF-8"));){
                this.driverConfiguration.load(in);
            }
            catch (Exception e) {
                logger.error("Cannot parse 2FA driver configuration", (Throwable)e);
            }
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return dialogArea;
    }

    private void updateDriverList(List<String> drivers) {
        this.comboDriverName.removeAll();
        for (int i = 0; i < drivers.size(); ++i) {
            this.comboDriverName.add(drivers.get(i));
            if (this.method == null || !drivers.get(i).equals(this.method.getDriver())) continue;
            this.comboDriverName.select(i);
            this.updateDriverConfigurationWidgets();
        }
        if (this.comboDriverName.getSelectionIndex() == -1 && this.comboDriverName.getItemCount() > 0) {
            this.comboDriverName.select(0);
            this.updateDriverConfigurationWidgets();
        }
    }

    private void updateDriverConfigurationWidgets() {
        String driverName;
        if (this.driverConfigurationArea != null) {
            this.driverConfigurationArea.dispose();
        }
        if ((driverName = this.comboDriverName.getText()).equals("Message")) {
            this.driverConfigurationArea = new Composite((Composite)this.dialogArea, 0);
            this.driverConfigurationArea.setLayout((Layout)new FillLayout());
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.driverConfigurationArea.setLayoutData((Object)gd);
            this.comboChannelName = WidgetHelper.createLabeledCombo((Composite)this.driverConfigurationArea, (int)8, (String)this.i18n.tr("Notification channel"), null);
            for (NotificationChannel n : this.notificationChannels) {
                this.comboChannelName.add(n.getName());
                if (!n.getName().equals(this.driverConfiguration.getProperty("ChannelName", ""))) continue;
                this.comboChannelName.select(this.comboChannelName.getItemCount() - 1);
            }
            if (this.comboChannelName.getSelectionIndex() == -1 && this.comboChannelName.getItemCount() > 0) {
                this.comboChannelName.select(0);
            }
        } else {
            this.driverConfigurationArea = null;
        }
        this.getShell().layout(true, true);
        this.getShell().pack();
    }

    protected void okPressed() {
        if (this.textName.getText().isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Method name should not be empty"));
            return;
        }
        String driverName = this.comboDriverName.getText();
        if (driverName.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Driver should be selected"));
            return;
        }
        if (driverName.equals("Message")) {
            this.driverConfiguration.setProperty("ChannelName", this.comboChannelName.getText());
        }
        String configuration = "";
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            this.driverConfiguration.store(out, null);
            configuration = new String(out.toByteArray(), "UTF-8");
        }
        catch (Exception e) {
            logger.error("Error serializing 2FA driver configuration", (Throwable)e);
        }
        if (this.method == null) {
            this.method = new TwoFactorAuthenticationMethod(this.textName.getText(), this.textDescription.getText(), driverName, configuration);
        } else {
            if (!this.method.getName().equals(this.textName.getText())) {
                this.isNameChanged = true;
                this.newName = this.textName.getText();
            }
            this.method.setDescription(this.textDescription.getText());
            this.method.setDriver(this.comboDriverName.getItem(this.comboDriverName.getSelectionIndex()));
            this.method.setConfiguration(configuration);
        }
        super.okPressed();
    }

    public TwoFactorAuthenticationMethod getMethod() {
        return this.method;
    }

    public boolean isNameChanged() {
        return this.isNameChanged;
    }

    public String getNewName() {
        return this.newName;
    }
}

