/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.base.widgets.LabeledCombo;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.propertypages.RuleBasePropertyPage;
import org.netxms.nxmc.modules.events.widgets.RuleEditor;
import org.xnap.commons.i18n.I18n;

public class RuleDowntimeControl
extends RuleBasePropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(RuleDowntimeControl.class);
    private LabeledCombo mode;
    private LabeledText tag;

    public RuleDowntimeControl(RuleEditor editor) {
        super(editor, LocalizationHelper.getI18n(RuleDowntimeControl.class).tr("Downtime Control"));
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.mode = new LabeledCombo(dialogArea, 0);
        this.mode.setLabel(this.i18n.tr("Control mode"));
        this.mode.add(this.i18n.tr("Do nothing"));
        this.mode.add(this.i18n.tr("Start downtime"));
        this.mode.add(this.i18n.tr("End downtime"));
        if ((this.rule.getFlags() & 0x10000) != 0) {
            this.mode.select(1);
        } else if ((this.rule.getFlags() & 0x20000) != 0) {
            this.mode.select(2);
        } else {
            this.mode.select(0);
        }
        this.mode.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.tag = new LabeledText(dialogArea, 0);
        this.tag.setLabel("Downtime tag");
        this.tag.setTextLimit(15);
        this.tag.setText(this.rule.getDowntimeTag());
        this.tag.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        int flags = this.rule.getFlags();
        switch (this.mode.getSelectionIndex()) {
            case 1: {
                flags |= 0x10000;
                flags &= 0xFFFDFFFF;
                break;
            }
            case 2: {
                flags |= 0x20000;
                flags &= 0xFFFEFFFF;
                break;
            }
            default: {
                flags &= 0xFFFCFFFF;
            }
        }
        this.rule.setFlags(flags);
        this.rule.setDowntimeTag(this.tag.getText().trim());
        this.editor.setModified(true);
        return true;
    }
}

