/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.widgets;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.datacollection.PerfTabDci;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.DashboardComposite;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.charts.api.ChartType;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.datacollection.views.HistoricalGraphView;
import org.netxms.nxmc.modules.datacollection.views.helpers.PerfViewGraphSettings;
import org.netxms.nxmc.modules.datacollection.widgets.PerfTabGraph;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.tools.ViewRefreshController;
import org.netxms.nxmc.tools.VisibilityValidator;
import org.xnap.commons.i18n.I18n;

public class PerfTabGraph
extends DashboardComposite
implements HistoricalGraphView.HistoricalChartOwner {
    private I18n i18n = LocalizationHelper.getI18n(PerfTabGraph.class);
    private long nodeId;
    private List<PerfTabDci> items = new ArrayList(4);
    private Chart chart;
    private View view;
    private ViewRefreshController refreshController = null;
    private boolean updateInProgress = false;
    private NXCSession session;
    private VisibilityValidator validator;
    private Action actionRefresh;
    private Action actionAdjustX;
    private Action actionAdjustY;
    private Action actionAdjustBoth;
    private Action[] presetActions;
    private PerfViewGraphSettings settings;

    public PerfTabGraph(Composite parent, long nodeId, PerfTabDci dci, PerfViewGraphSettings settings, View view, VisibilityValidator validator) {
        super(parent, 2048);
        this.nodeId = nodeId;
        this.view = view;
        this.validator = validator;
        this.settings = settings;
        this.items.add(dci);
        this.session = Registry.getSession();
        this.setLayout((Layout)new FillLayout());
        ChartConfiguration chartConfiguration = new ChartConfiguration();
        chartConfiguration.setZoomEnabled(false);
        chartConfiguration.setTitleVisible(true);
        chartConfiguration.setTitle(settings.getRuntimeTitle());
        chartConfiguration.setLegendVisible(settings.isShowLegendAlways());
        chartConfiguration.setExtendedLegend(settings.isExtendedLegend());
        chartConfiguration.setLogScale(settings.isLogScaleEnabled());
        chartConfiguration.setUseMultipliers(settings.isUseMultipliers());
        chartConfiguration.setStacked(settings.isStacked());
        chartConfiguration.setTranslucent(settings.isTranslucent());
        chartConfiguration.setAutoScale(settings.isAutoScale());
        chartConfiguration.setMinYScaleValue(settings.getMinYScaleValue());
        chartConfiguration.setMaxYScaleValue(settings.getMaxYScaleValue());
        this.chart = new Chart((Composite)this, 0, ChartType.LINE, chartConfiguration);
        Date from = new Date(System.currentTimeMillis() - settings.getTimeRangeMillis());
        Date to = new Date(System.currentTimeMillis());
        this.chart.setTimeRange(from, to);
        GraphItem item = new GraphItem(nodeId, dci.getId(), null, settings.getRuntimeName(), "", settings.getType(), settings.isAutomaticColor() ? -1 : settings.getColorAsInt());
        item.setInverted(settings.isInvertedValues());
        item.setShowThresholds(settings.isShowThresholds());
        item.setMeasurementUnit(dci.getMeasurementUnit());
        this.chart.addParameter(item);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.chart.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createChartContextMenu();
    }

    private void createActions() {
        this.actionRefresh = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAdjustX = HistoricalGraphView.createAction((HistoricalGraphView.ChartActionType)HistoricalGraphView.ChartActionType.ADJUST_X, (HistoricalGraphView.HistoricalChartOwner)this);
        this.actionAdjustY = HistoricalGraphView.createAction((HistoricalGraphView.ChartActionType)HistoricalGraphView.ChartActionType.ADJUST_Y, (HistoricalGraphView.HistoricalChartOwner)this);
        this.actionAdjustBoth = HistoricalGraphView.createAction((HistoricalGraphView.ChartActionType)HistoricalGraphView.ChartActionType.ADJUST_BOTH, (HistoricalGraphView.HistoricalChartOwner)this);
        this.presetActions = HistoricalGraphView.createPresetActions((HistoricalGraphView.PresetHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createChartContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        this.chart.setMenuManager(manager);
    }

    private void fillContextMenu(IMenuManager manager) {
        MenuManager presets = new MenuManager("&Presets");
        for (int i = 0; i < this.presetActions.length; ++i) {
            presets.add((IAction)this.presetActions[i]);
        }
        manager.add((IContributionItem)presets);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAdjustBoth);
        manager.add((IAction)this.actionAdjustX);
        manager.add((IAction)this.actionAdjustY);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(PerfTabDci dci, PerfViewGraphSettings settings) {
        this.chart.getConfiguration().setLegendVisible(true);
        if (settings.isExtendedLegend()) {
            this.chart.getConfiguration().setExtendedLegend(true);
        }
        List list = this.items;
        synchronized (list) {
            this.items.add(dci);
            GraphItem item = new GraphItem(this.nodeId, dci.getId(), null, settings.getRuntimeName(), "", settings.getType(), settings.isAutomaticColor() ? -1 : settings.getColorAsInt());
            item.setInverted(settings.isInvertedValues());
            item.setShowThresholds(settings.isShowThresholds());
            item.setMeasurementUnit(dci.getMeasurementUnit());
            this.chart.addParameter(item);
        }
    }

    public void start() {
        this.chart.rebuild();
        this.refreshController = new ViewRefreshController(this.view, 30, (Runnable)new /* Unavailable Anonymous Inner Class!! */, this.validator);
        if (this.validator.isVisible()) {
            this.refreshData();
        }
    }

    public void refreshData() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        7 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    private void openHistoryGraph() {
        ArrayList<ChartDciConfig> graphItems = new ArrayList<ChartDciConfig>(this.items.size());
        for (PerfTabDci dci : this.items) {
            ChartDciConfig cd = new ChartDciConfig();
            cd.nodeId = this.nodeId;
            cd.dciId = dci.getId();
            cd.name = dci.getDescription();
            cd.dciName = dci.getDescription();
            cd.dciDescription = dci.getDescription();
            graphItems.add(cd);
        }
        AbstractObject object = this.view instanceof ObjectView ? ((ObjectView)this.view).getObject() : this.session.findObjectById(this.nodeId);
        this.view.openView((View)new HistoricalGraphView(object, graphItems, 0L));
    }

    public Chart getChart() {
        return this.chart;
    }
}

