/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.EntireNetwork;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.base.widgets.helpers.SearchQueryAttribute;
import org.netxms.nxmc.base.widgets.helpers.SearchQueryContentProposalProvider;
import org.netxms.nxmc.base.windows.MainWindow;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.views.BaseDataCollectionView;
import org.netxms.nxmc.modules.datacollection.views.SummaryDataCollectionView;
import org.netxms.nxmc.resources.SharedIcons;
import org.xnap.commons.i18n.I18n;

public class SummaryDataCollectionView
extends BaseDataCollectionView {
    private final I18n i18n = LocalizationHelper.getI18n(SummaryDataCollectionView.class);
    public static final int LV_COLUMN_SOURCE = 0;
    private final SearchQueryAttribute[] attributeProposals = new SearchQueryAttribute[]{new SearchQueryAttribute("Description:"), new SearchQueryAttribute("Guid:"), new SearchQueryAttribute("Id:"), new SearchQueryAttribute("Name:"), new SearchQueryAttribute("NOT"), new SearchQueryAttribute("PollingInterval:"), new SearchQueryAttribute("RetentionTime:"), new SearchQueryAttribute("SourceNode:")};
    private LabeledText queryEditor;
    private Button startButton;
    private String searchFilter;
    private ContentProposalAdapter proposalAdapter;
    private Action actionShowOnNode;

    public SummaryDataCollectionView() {
        super("objects.data-collection-summary", false);
    }

    protected void postClone(View view) {
        super.postClone(view);
        SummaryDataCollectionView origin = (SummaryDataCollectionView)view;
        this.queryEditor.setText(origin.queryEditor.getText());
        this.searchFilter = origin.searchFilter;
        this.viewer.setInput(origin.viewer.getInput());
    }

    protected void createContent(Composite parent) {
        parent.setLayout((Layout)new FormLayout());
        Composite searchBar = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        searchBar.setLayout((Layout)gridLayout);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        searchBar.setLayoutData((Object)fd);
        this.queryEditor = new LabeledText(searchBar, 0);
        this.queryEditor.setLabel("Search string");
        this.queryEditor.getTextControl().addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.queryEditor.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.startButton = new Button(searchBar, 8);
        this.startButton.setImage(SharedIcons.IMG_EXECUTE);
        this.startButton.setText("Start");
        this.startButton.setToolTipText("Start search");
        this.startButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.startButton.setLayoutData((Object)new GridData(4, 1024, false, false));
        Composite mainContent = new Composite(parent, 0);
        mainContent.setLayout((Layout)new FillLayout());
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)searchBar);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        mainContent.setLayoutData((Object)fd);
        super.createContent(mainContent);
        this.proposalAdapter = new ContentProposalAdapter(this.queryEditor.getControl(), (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new SearchQueryContentProposalProvider(this.attributeProposals), null, null);
        this.proposalAdapter.setPropagateKeys(true);
        this.proposalAdapter.setProposalAcceptanceStyle(3);
        this.proposalAdapter.addContentProposalListener((IContentProposalListener)new /* Unavailable Anonymous Inner Class!! */);
        this.enableFilterAutocomplete((IContentProposalProvider)new SearchQueryContentProposalProvider(this.attributeProposals));
    }

    private static boolean isStopCharacter(char ch) {
        return ch == ':' || ch == ',' || Character.isWhitespace(ch);
    }

    protected void getDataFromServer(Runnable callback) {
        if (this.getObject() == null || this.searchFilter == null || this.searchFilter.isEmpty()) {
            this.viewer.setInput((Object)new DciValue[0]);
            return;
        }
        AbstractObject obj = this.getObject();
        String searchString = this.searchFilter;
        4 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    protected void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowOnNode);
    }

    protected void createActions() {
        super.createActions();
        this.actionShowOnNode = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void showOnNode() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        DciValue dci = (DciValue)selection.getFirstElement();
        MainWindow.switchToObject((long)dci.getNodeId(), (long)dci.getId());
    }

    protected boolean isHideOwner() {
        return false;
    }

    public boolean isValidForContext(Object context) {
        if (context == null) {
            return false;
        }
        return context instanceof Container || context instanceof EntireNetwork || context instanceof ServiceRoot || context instanceof Subnet;
    }

    static /* synthetic */ NXCSession access$000(SummaryDataCollectionView x0) {
        return x0.session;
    }
}

