/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.agentmanagement.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.agent.config.AgentConfiguration;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.agentmanagement.widgets.AgentConfigEditor;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptEditor;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class StoredAgentConfigurationEditor
extends ConfigurationView {
    private final I18n i18n = LocalizationHelper.getI18n(StoredAgentConfigurationEditor.class);
    private NXCSession session;
    private long configurationId;
    private String configurationName;
    private boolean modified = false;
    private Composite editorContent;
    private AgentConfigEditor contentEditor;
    private ScriptEditor filterEditor;
    private Action actionSave;

    public StoredAgentConfigurationEditor(long configurationId, String configurationName) {
        super(configurationName, ResourceManager.getImageDescriptor((String)"icons/object-views/agent-config.png"), "StoredAgentConfigurationEditor." + Long.toString(configurationId), false);
        this.configurationId = configurationId;
        this.configurationName = configurationName;
        this.session = Registry.getSession();
    }

    protected void createContent(Composite parent) {
        this.editorContent = new Composite(parent, 0);
        this.editorContent.setLayout((Layout)new GridLayout());
        Label label = new Label(this.editorContent, 0);
        label.setText(this.i18n.tr("Filter"));
        GridData gridData = new GridData();
        gridData.verticalIndent = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.filterEditor = new ScriptEditor(this.editorContent, 2048, 768, true, "Variables:\n\t$1\tIP address\n\t$2\tplatform name\n\t$3\tmajor agent version number\n\t$4\tminor agent version number\n\t$5\trelease number\n\nReturn value: true if this configuration should be sent to agent");
        this.filterEditor.getTextWidget().addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.filterEditor.setLayoutData((Object)gridData);
        label = new Label(this.editorContent, 0);
        label.setText(this.i18n.tr("Configuration file"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalIndent = 5;
        label.setLayoutData((Object)gridData);
        this.contentEditor = new AgentConfigEditor(this.editorContent, 2048, 768);
        this.contentEditor.getTextWidget().addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.contentEditor.setLayoutData((Object)gridData);
        this.createActions();
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.refresh();
    }

    private void onTextModify() {
        if (!this.modified) {
            this.modified = true;
            this.actionSave.setEnabled(true);
        }
    }

    private void createActions() {
        this.actionSave = new /* Unavailable Anonymous Inner Class!! */;
        this.actionSave.setEnabled(false);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
    }

    public String getSaveOnExitPrompt() {
        return this.i18n.tr("There are unsaved changes to configuration file. Do you want to save them?");
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void save() {
        AgentConfiguration configuration = new AgentConfiguration();
        configuration.setId(this.configurationId);
        configuration.setName(this.configurationName);
        configuration.setFilter(this.filterEditor.getText());
        configuration.setContent(this.contentEditor.getText());
        new /* Unavailable Anonymous Inner Class!! */.start();
    }
}

