/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.views;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.views.NavigationView;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.PerspectiveConfiguration;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.services.ConfigurationPerspectiveElement;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class ConfigurationPerspective
extends Perspective {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationPerspective.class);
    private final I18n i18n = LocalizationHelper.getI18n(ConfigurationPerspective.class);
    private List<ConfigurationPerspectiveElement> elements = new ArrayList();
    private ConfigurationPerspectiveElement previousSelectedElement = null;
    private NavigationView navigationView;

    public ConfigurationPerspective() {
        super("configuration", LocalizationHelper.getI18n(ConfigurationPerspective.class).tr("Configuration"), ResourceManager.getImage((String)"icons/perspective-configuration.png"));
        ServiceLoader<ConfigurationPerspectiveElement> loader = ServiceLoader.load(ConfigurationPerspectiveElement.class, this.getClass().getClassLoader());
        for (ConfigurationPerspectiveElement e : loader) {
            logger.debug("Adding configuration element " + e.getName());
            this.elements.add(e);
        }
        this.elements.sort(new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void configurePerspective(PerspectiveConfiguration configuration) {
        super.configurePerspective(configuration);
        configuration.hasNavigationArea = true;
        configuration.multiViewNavigationArea = false;
        configuration.multiViewMainArea = false;
        configuration.hasSupplementalArea = false;
        configuration.priority = 250;
    }

    protected void configureViews() {
        this.navigationView = new /* Unavailable Anonymous Inner Class!! */;
        this.addNavigationView(this.navigationView);
    }

    protected void navigationSelectionChanged(IStructuredSelection selection) {
        ConfigurationPerspectiveElement currentElement = (ConfigurationPerspectiveElement)selection.getFirstElement();
        if (this.previousSelectedElement == currentElement) {
            return;
        }
        ConfigurationView currentView = (ConfigurationView)this.getMainView();
        if (currentView != null && currentView.isModified()) {
            int choice = MessageDialogHelper.openQuestionWithCancel((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Unsaved Changes"), (String)currentView.getSaveOnExitPrompt());
            if (choice == 2) {
                this.navigationView.setSelection((Object)this.previousSelectedElement);
                return;
            }
            if (choice == 0) {
                currentView.save();
            }
        }
        if (currentElement != null) {
            this.setMainView((View)currentElement.createView());
        } else {
            this.setMainView(null);
        }
        this.previousSelectedElement = currentElement;
    }
}

