/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.views;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.objects.queries.ObjectQueryResult;
import org.netxms.ui.eclipse.actions.CopyTableRowsAction;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.objectbrowser.views.helpers.ObjectQueryResultLabelProvider;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ObjectQueryResultView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.objectbrowser.views.ObjectQueryResultView";
    private SortableTableViewer viewer;
    private Action actionExportToCSV;
    private Action actionCopyToClipboard;
    private Action actionCopySelectionToClipboard;

    public void createPartControl(Composite parent) {
        this.viewer = new SortableTableViewer(parent, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ObjectQueryResultLabelProvider(this.viewer.getTable()));
        this.createActions();
        this.contributeToActionBars();
        this.createContextMenu();
    }

    private void createActions() {
        this.actionExportToCSV = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, false);
        this.actionCopyToClipboard = new CopyTableRowsAction((ColumnViewer)this.viewer, false);
        this.actionCopyToClipboard.setImageDescriptor(SharedIcons.COPY_TO_CLIPBOARD);
        this.actionCopySelectionToClipboard = new CopyTableRowsAction((ColumnViewer)this.viewer, true);
        this.actionCopySelectionToClipboard.setImageDescriptor(SharedIcons.COPY_TO_CLIPBOARD);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionCopyToClipboard);
        manager.add((IAction)this.actionExportToCSV);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCopyToClipboard);
        manager.add((IAction)this.actionExportToCSV);
    }

    private void createContextMenu() {
        final MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                IStructuredSelection selection = ObjectQueryResultView.this.viewer.getStructuredSelection();
                if (!selection.isEmpty()) {
                    manager.add((IAction)ObjectQueryResultView.this.actionCopySelectionToClipboard);
                }
            }
        });
        Menu menu = manager.createContextMenu((Control)this.viewer.getTable());
        this.viewer.getTable().setMenu(menu);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void setContent(List<ObjectQueryResult> resultSet, String queryName) {
        this.setPartName(String.valueOf(queryName) + " - " + RegionalSettings.getDateTimeFormat().format(new Date()));
        this.updateResultTable(resultSet);
    }

    private void resetResultTable() {
        TableColumn[] columns = this.viewer.getTable().getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].dispose();
            ++i;
        }
    }

    private void updateResultTable(List<ObjectQueryResult> objects) {
        this.resetResultTable();
        HashSet<String> registeredProperties = new HashSet<String>();
        for (ObjectQueryResult r : objects) {
            for (String n : r.getPropertyNames()) {
                if (registeredProperties.contains(n)) continue;
                TableColumn tc = this.viewer.addColumn(n, 200);
                tc.setData("propertyName", (Object)n);
                registeredProperties.add(n);
            }
        }
        this.viewer.setInput(objects);
    }
}

