/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.snmp;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MibCompilationLogEntry {
    private static Logger logger = LoggerFactory.getLogger(MibCompilationLogEntry.class);
    private MessageType type = null;
    private int errorCode = 0;
    private String fileName = null;
    private String text = null;

    private MibCompilationLogEntry() {
    }

    public static MibCompilationLogEntry createEntry(String output) {
        int separator = output.indexOf(":");
        if (separator == -1) {
            return null;
        }
        MessageType type = MessageType.getValue(output.substring(0, separator));
        if (type == null) {
            return null;
        }
        output = output.substring(separator + 1);
        MibCompilationLogEntry entry = new MibCompilationLogEntry();
        entry.type = type;
        switch (type) {
            case STATE: {
                String[] items = output.split(":");
                if (items.length < 2) {
                    return null;
                }
                try {
                    entry.errorCode = Integer.parseInt(items[0]);
                }
                catch (NumberFormatException e) {
                    logger.debug("Failed to parse error code: " + items[0]);
                }
                entry.text = items[1];
                break;
            }
            case STAGE: {
                entry.text = output;
                break;
            }
            case FILE: {
                entry.fileName = output;
                break;
            }
            case WARNING: 
            case ERROR: {
                int end = output.indexOf(":");
                if (end == -1) {
                    return null;
                }
                try {
                    entry.errorCode = Integer.parseInt(output.substring(0, end));
                }
                catch (NumberFormatException e) {
                    logger.debug("Failed to parse error code: " + output.substring(0, end));
                }
                int start = output.indexOf(":{");
                end = output.indexOf("}:");
                if (start == -1 || end == -1) {
                    return null;
                }
                entry.fileName = output.substring(start + 2, end);
                entry.text = output.substring(end + 2);
            }
        }
        return entry;
    }

    public String toString() {
        return "MibCompilationLogEntry [type=" + (Object)((Object)this.type) + ", errorCode=" + this.errorCode + ", fileName=" + this.fileName + ", text=" + this.text + "]";
    }

    public boolean isErrorInformation() {
        return this.type == MessageType.ERROR || this.type == MessageType.WARNING;
    }

    public MessageType getType() {
        return this.type;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getText() {
        return this.text;
    }

    public static enum MessageType {
        STATE("S"),
        STAGE("P"),
        FILE("F"),
        WARNING("W"),
        ERROR("E");

        private String symbol;

        private MessageType(String string2) {
            this.symbol = string2;
        }

        public static MessageType getValue(String text) {
            MessageType[] messageTypeArray = MessageType.values();
            int n = messageTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MessageType type = messageTypeArray[n2];
                if (type.symbol.equalsIgnoreCase(text)) {
                    return type;
                }
                ++n2;
            }
            return null;
        }
    }
}

