/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.snmp.SnmpUsmCredential;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class SnmpUsmCredentialsLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final I18n i18n = LocalizationHelper.getI18n(SnmpUsmCredentialsLabelProvider.class);
    private final String[] authMethodName = new String[]{this.i18n.tr("None"), "MD5", "SHA1", "SHA224", "SHA256", "SHA384", "SHA512"};
    private final String[] privMethodName = new String[]{this.i18n.tr("None"), "DES", "AES-128", "AES-192", "AES-256"};
    private boolean maskMode = true;

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        SnmpUsmCredential c = (SnmpUsmCredential)element;
        switch (columnIndex) {
            case 0: {
                return c.getName();
            }
            case 1: {
                return this.authMethodName[c.getAuthMethod()];
            }
            case 2: {
                return this.privMethodName[c.getPrivMethod()];
            }
            case 3: {
                return this.maskMode ? WidgetHelper.maskPassword((String)c.getAuthPassword()) : c.getAuthPassword();
            }
            case 4: {
                return this.maskMode ? WidgetHelper.maskPassword((String)c.getPrivPassword()) : c.getPrivPassword();
            }
            case 5: {
                return c.getComment();
            }
        }
        return null;
    }

    public boolean isMaskMode() {
        return this.maskMode;
    }

    public void setMaskMode(boolean maskMode) {
        this.maskMode = maskMode;
    }
}

