/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.ServicesView;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class ServicesView
extends ObjectView {
    private final I18n i18n = LocalizationHelper.getI18n(ServicesView.class);
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_DISPLAY_NAME = 1;
    public static final int COLUMN_STATE = 2;
    public static final int COLUMN_PID = 3;
    public static final int COLUMN_TYPE = 4;
    public static final int COLUMN_STARTUP = 5;
    public static final int COLUMN_RUN_AS = 6;
    public static final int COLUMN_CMDLINE = 7;
    public static final int COLUMN_DEPENDENCIES = 8;
    private SortableTableViewer viewer;
    private Action actionStart;
    private Action actionStop;
    private Action actionSetAutoStart;
    private Action actionSetManualStart;
    private Action actionDisable;
    private String filterString = null;

    public ServicesView() {
        super(LocalizationHelper.getI18n(ServicesView.class).tr("Services"), ResourceManager.getImageDescriptor((String)"icons/object-views/services.png"), "objects.services", true);
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof Node && ((Node)context).hasAgent() && ((Node)context).getPlatformName().startsWith("windows-");
    }

    public int getPriority() {
        return 70;
    }

    protected void onObjectChange(AbstractObject object) {
        if (this.isActive()) {
            this.refresh();
        } else {
            this.viewer.setInput((Object)new Object[0]);
        }
    }

    public void activate() {
        super.activate();
        this.refresh();
    }

    protected void createContent(Composite parent) {
        String[] names = new String[]{"Name", "Display name", "State", "PID", "Type", "Startup", "Run as", "Command line", "Dependencies"};
        int[] widths = new int[]{180, 280, 90, 80, 100, 150, 300, 500, 200};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ServiceLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ServiceComparator());
        this.viewer.addFilter((ViewerFilter)new ServiceFilter(this));
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)"ServiceTable");
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createContextMenu();
    }

    private void createActions() {
        this.actionStart = new /* Unavailable Anonymous Inner Class!! */;
        this.actionStop = new /* Unavailable Anonymous Inner Class!! */;
        this.actionSetAutoStart = new /* Unavailable Anonymous Inner Class!! */;
        this.actionSetManualStart = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDisable = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        MenuManager startTypeMenu = new MenuManager("&Change start type");
        startTypeMenu.add((IAction)this.actionSetAutoStart);
        startTypeMenu.add((IAction)this.actionSetManualStart);
        startTypeMenu.add((IAction)this.actionDisable);
        manager.add((IAction)this.actionStart);
        manager.add((IAction)this.actionStop);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)startTypeMenu);
    }

    public void refresh() {
        long nodeId = this.getObjectId();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void executeAgentAction(String action) {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        ArrayList<String> services = new ArrayList<String>(selection.size());
        for (Object o : selection.toList()) {
            services.add(((Service)o).data[0]);
        }
        long nodeId = this.getObjectId();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void onFilterModify() {
        this.filterString = this.getFilterText();
        this.viewer.refresh(false);
    }
}

