/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.widgets.helpers;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.tools.FontTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapObjectSyncer {
    private static Logger logger = LoggerFactory.getLogger(FontTools.class);
    private Map<Long, Set<Long>> objectIdToMap = new HashMap();
    private Map<Long, Set<Long>> requestData = new HashMap();
    private Map<Long, Integer> mapReferenceCount = new HashMap();
    private NXCSession session = Registry.getSession();
    private Thread syncThread = new Thread(() -> this.syncObjects());
    private volatile boolean syncRunning = true;

    public static MapObjectSyncer getInstance() {
        MapObjectSyncer instance = (MapObjectSyncer)Registry.getSingleton(MapObjectSyncer.class);
        if (instance == null) {
            instance = new MapObjectSyncer();
            Registry.setSingleton(MapObjectSyncer.class, (Object)instance);
        }
        return instance;
    }

    public MapObjectSyncer() {
        this.syncThread.setDaemon(true);
        this.syncThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncObjects() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (this.syncRunning) {
            Map map = this.requestData;
            synchronized (map) {
                try {
                    if (this.requestData.size() > 0) {
                        for (Map.Entry entry : this.requestData.entrySet()) {
                            this.session.syncObjectSet((Collection)entry.getValue(), ((Long)entry.getKey()).longValue(), 5);
                        }
                    }
                }
                catch (Exception e2) {
                    logger.error("Exception in sync last objects thread - " + e2.getMessage(), (Throwable)e2);
                }
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void dispose() {
        this.syncRunning = false;
        this.syncThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObjects(long mapId, Set<Long> mapObjectIds, Set<Long> utilizationInterface) {
        HashSet<Long> uniqueObjects = new HashSet<Long>();
        Map map = this.requestData;
        synchronized (map) {
            Integer count = (Integer)this.mapReferenceCount.get(mapId);
            if (count != null) {
                this.mapReferenceCount.put(mapId, count + 1);
                return;
            }
            this.mapReferenceCount.put(mapId, 1);
            for (Long objectId : mapObjectIds) {
                AbstractObject object = this.session.findObjectById(objectId.longValue(), true);
                if (object == null || !object.isPartialObject() && !utilizationInterface.contains(objectId)) continue;
                HashSet<Long> objectMaps = (HashSet<Long>)this.objectIdToMap.get(objectId);
                if (objectMaps == null || objectMaps.isEmpty()) {
                    objectMaps = new HashSet<Long>();
                    this.objectIdToMap.put(objectId, objectMaps);
                    uniqueObjects.add(objectId);
                }
                objectMaps.add(mapId);
            }
            if (uniqueObjects.size() > 0) {
                this.requestData.put(mapId, uniqueObjects);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObjects(long mapId, Set<Long> mapObjectIds) {
        Map map = this.requestData;
        synchronized (map) {
            Integer count = (Integer)this.mapReferenceCount.get(mapId);
            if (count == null) {
                return;
            }
            if (count > 1) {
                this.mapReferenceCount.put(mapId, count - 1);
                return;
            }
            this.mapReferenceCount.remove(mapId);
            if (this.mapReferenceCount.isEmpty()) {
                this.objectIdToMap.clear();
                this.requestData.clear();
                return;
            }
            Set mapSpecificObjects = (Set)this.requestData.remove(mapId);
            for (Long objectId : mapObjectIds) {
                Set maps = (Set)this.objectIdToMap.get(objectId);
                if (maps == null) continue;
                maps.remove(mapId);
                if (maps.isEmpty() || mapSpecificObjects == null || !mapSpecificObjects.contains(objectId)) continue;
                boolean added = false;
                for (Long otherMapId : maps) {
                    Set otherMapObjects = (Set)this.requestData.get(otherMapId);
                    if (otherMapObjects == null) continue;
                    otherMapObjects.add(objectId);
                    added = true;
                    break;
                }
                if (added) continue;
                HashSet<Long> newSet = new HashSet<Long>();
                newSet.add(objectId);
                this.requestData.put((Long)maps.iterator().next(), newSet);
            }
        }
    }
}

