/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.filemanager.views;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.filemanager.views.helpers.ServerFileComparator;
import org.netxms.nxmc.modules.filemanager.views.helpers.ServerFileLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class ServerFileManager
extends ConfigurationView
implements SessionListener {
    private final I18n i18n = LocalizationHelper.getI18n(ServerFileManager.class);
    private static final String TABLE_CONFIG_PREFIX = "ServerFileManager";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_SIZE = 2;
    public static final int COLUMN_MODIFYED = 3;
    private NXCSession session = Registry.getSession();
    private SortableTableViewer viewer;
    private String filterString = "";
    private Action actionUpload;
    private Action actionRename;
    private Action actionDelete;

    public ServerFileManager() {
        super(LocalizationHelper.getI18n(ServerFileManager.class).tr("Server Files"), ResourceManager.getImageDescriptor((String)"icons/config-views/server-files.png"), TABLE_CONFIG_PREFIX, true);
    }

    public void createContent(Composite parent) {
        String[] columnNames = new String[]{this.i18n.tr("Name"), this.i18n.tr("Type"), this.i18n.tr("Size"), this.i18n.tr("Modified")};
        int[] columnWidths = new int[]{300, 150, 300, 300};
        this.viewer = new SortableTableViewer(parent, columnNames, columnWidths, 0, 128, -1);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ServerFileLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ServerFileComparator());
        this.viewer.addFilter((ViewerFilter)new /* Unavailable Anonymous Inner Class!! */);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        TableViewerEditor.create((TableViewer)this.viewer, (ColumnViewerEditorActivationStrategy)new /* Unavailable Anonymous Inner Class!! */, (int)1);
        TextCellEditor editor = new TextCellEditor((Composite)this.viewer.getTable(), 2048);
        this.viewer.setCellEditors(new CellEditor[]{editor});
        this.viewer.setColumnProperties(new String[]{"name"});
        this.viewer.setCellModifier((ICellModifier)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createContextMenu();
        this.session.addListener((SessionListener)this);
        this.refresh();
    }

    private void createActions() {
        this.actionUpload = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+U", (IAction)this.actionUpload);
        this.actionRename = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("F2", (IAction)this.actionRename);
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionUpload);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        if (!this.viewer.getStructuredSelection().isEmpty()) {
            mgr.add((IAction)this.actionRename);
            mgr.add((IAction)this.actionDelete);
            mgr.add((IContributionItem)new Separator());
        }
        mgr.add((IAction)this.actionUpload);
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void uploadFile() {
        FileDialog fd = new FileDialog(this.getWindow().getShell(), 4098);
        fd.setText("Select Files");
        String selection = fd.open();
        if (selection == null) {
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String fname : fd.getFileNames()) {
            files.add(fname.charAt(0) == File.separatorChar ? new File(fname) : new File(new File(selection).getParentFile(), fname));
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void deleteFile() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openConfirm((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Delete File"), (String)this.i18n.tr("Are you sure you want to delete selected files?"))) {
            return;
        }
        Object[] objects = selection.toArray();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void notificationHandler(SessionNotification n) {
        if (n.getCode() == 1025 && n.getSubCode() == 0L) {
            this.getDisplay().asyncExec(() -> this.refresh());
        }
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        super.dispose();
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

