/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.alarms;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.events.Alarm;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class AlarmNotifier {
    private static final Logger logger = LoggerFactory.getLogger(AlarmNotifier.class);
    public static final String[] SEVERITY_TEXT = new String[]{"NORMAL", "WARNING", "MINOR", "MAJOR", "CRITICAL", "REMINDER"};
    private static final String LOCAL_SOUND_ID = "AlarmNotifier.LocalSound";
    private static final int MAX_PLAY_QUEUE_LINE = 5;
    private I18n i18n = LocalizationHelper.getI18n(AlarmNotifier.class);
    private Display display;
    private SessionListener listener = null;
    private Map<Long, Integer> alarmStates = new HashMap();
    private int outstandingAlarms = 0;
    private long lastReminderTime = 0L;
    private NXCSession session;
    private PreferenceStore ps;
    private LinkedBlockingQueue<String> soundQueue = new LinkedBlockingQueue(4);
    private File soundFilesDirectory;
    private Map<Long, Long> alarmNotificationTimestamp = new HashMap();
    private long lastNotificationTimestamp;

    private static AlarmNotifier getInstance() {
        return (AlarmNotifier)Registry.getSingleton(AlarmNotifier.class);
    }

    private static AlarmNotifier getInstance(Display display) {
        return (AlarmNotifier)Registry.getSingleton(AlarmNotifier.class, (Display)display);
    }

    public static void init(NXCSession session, Display display) {
        Registry.setSingleton((Display)display, AlarmNotifier.class, (Object)new AlarmNotifier(session, display));
    }

    private AlarmNotifier(NXCSession session, Display display) {
        this.session = session;
        this.display = display;
        this.ps = PreferenceStore.getInstance((Display)display);
        this.soundFilesDirectory = new File(Registry.getStateDir((Display)display), "sounds");
        if (!this.soundFilesDirectory.isDirectory()) {
            this.soundFilesDirectory.mkdirs();
        }
        this.checkSounds();
        this.lastReminderTime = System.currentTimeMillis();
        try {
            HashMap alarms = session.getAlarms();
            for (Alarm a : alarms.values()) {
                this.alarmStates.put(a.getId(), a.getState());
                if (a.getState() != 0) continue;
                ++this.outstandingAlarms;
            }
            logger.info(String.format("Received %d alarms from server (%d outstanding)", alarms.size(), this.outstandingAlarms));
        }
        catch (Exception e) {
            logger.error("Exception while initializing alarm notifier", (Throwable)e);
        }
        this.listener = new /* Unavailable Anonymous Inner Class!! */;
        session.addListener(this.listener);
        Thread reminderThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */, "AlarmReminderThread");
        reminderThread.setDaemon(true);
        reminderThread.start();
        Thread playerThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */, "AlarmSoundPlayer");
        playerThread.setDaemon(true);
        playerThread.start();
    }

    private void checkSounds() {
        for (String s : SEVERITY_TEXT) {
            this.getSoundAndDownloadIfRequired(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSoundAndDownloadIfRequired(String severity) {
        String soundName;
        block12: {
            soundName = this.ps.getAsString("AlarmNotifier.Sound." + severity);
            if (soundName == null || soundName.isEmpty()) {
                return null;
            }
            if (!this.isSoundFileExist(soundName)) {
                try {
                    File fileContent = this.session.downloadFileFromServer(soundName);
                    if (fileContent != null) {
                        FileInputStream src = null;
                        FileOutputStream dest = null;
                        try {
                            src = new FileInputStream(fileContent);
                            File f = new File(this.soundFilesDirectory, soundName);
                            f.createNewFile();
                            dest = new FileOutputStream(f);
                            FileChannel fcSrc = src.getChannel();
                            dest.getChannel().transferFrom(fcSrc, 0L, fcSrc.size());
                            break block12;
                        }
                        catch (IOException e) {
                            logger.error("Cannot copy sound file", (Throwable)e);
                            break block12;
                        }
                        finally {
                            if (src != null) {
                                src.close();
                            }
                            if (dest != null) {
                                dest.close();
                            }
                        }
                    }
                    logger.error("Cannot download sound file " + soundName + " from server");
                    soundName = null;
                }
                catch (Exception e) {
                    soundName = null;
                    this.ps.set("AlarmNotifier.Sound." + severity, "");
                    this.display.asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                }
            }
        }
        return soundName;
    }

    private boolean isSoundFileExist(String name) {
        if (name.isEmpty()) {
            return true;
        }
        File f = new File(this.soundFilesDirectory, name);
        return f.isFile();
    }

    public static void stop() {
        NXCSession session = Registry.getSession();
        AlarmNotifier instance = AlarmNotifier.getInstance();
        if (session != null && instance != null && instance.listener != null) {
            session.removeListener(instance.listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playSounOnAlarm(Alarm alarm) {
        if (this.ps.getAsBoolean("AlarmNotifier.LocalSound", false)) {
            long now = new Date().getTime();
            Map map = this.alarmNotificationTimestamp;
            synchronized (map) {
                boolean playSound = false;
                if (now - this.lastNotificationTimestamp > 2000L) {
                    playSound = true;
                    this.alarmNotificationTimestamp.clear();
                } else {
                    Long time = (Long)this.alarmNotificationTimestamp.get(alarm.getId());
                    if (time == null || now - time > 500L) {
                        playSound = true;
                    }
                }
                if (playSound) {
                    if (this.soundQueue.size() <= 5) {
                        this.lastNotificationTimestamp = now;
                        this.alarmNotificationTimestamp.put(alarm.getId(), now);
                        this.soundQueue.offer(SEVERITY_TEXT[alarm.getCurrentSeverity().getValue()]);
                    } else {
                        logger.warn("Too many sound to play in queue");
                    }
                }
            }
        }
    }

    public static void playSounOnAlarm(Alarm alarm, Display display) {
        AlarmNotifier.getInstance((Display)display).playSounOnAlarm(alarm);
    }

    private void processNewAlarm(Alarm alarm) {
        Integer state = (Integer)this.alarmStates.get(alarm.getId());
        if (state != null && state == 0) {
            --this.outstandingAlarms;
        }
        this.alarmStates.put(alarm.getId(), alarm.getState());
        if (alarm.getState() != 0) {
            return;
        }
        if (!this.ps.getAsBoolean("AlarmNotifier.LocalSound", false)) {
            if (this.soundQueue.size() <= 5) {
                this.soundQueue.offer(SEVERITY_TEXT[alarm.getCurrentSeverity().getValue()]);
            } else {
                logger.warn("Too many sound to play in queue");
            }
        }
        if (this.outstandingAlarms == 0) {
            this.lastReminderTime = System.currentTimeMillis();
        }
        ++this.outstandingAlarms;
    }
}

