/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.layouts.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.gef4.zest.layouts.LayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.dataStructures.DisplayIndependentDimension;
import org.eclipse.gef4.zest.layouts.dataStructures.DisplayIndependentRectangle;
import org.eclipse.gef4.zest.layouts.interfaces.EntityLayout;
import org.eclipse.gef4.zest.layouts.interfaces.LayoutContext;

public class HorizontalShiftAlgorithm
implements LayoutAlgorithm {
    private static final double DELTA = 10.0;
    private static final double VSPACING = 16.0;
    private LayoutContext context;

    @Override
    public void applyLayout(boolean clean) {
        if (!clean) {
            return;
        }
        ArrayList rowsList = new ArrayList();
        EntityLayout[] entities = this.context.getEntities();
        int i = 0;
        while (i < entities.length) {
            this.addToRowList(entities[i], rowsList);
            ++i;
        }
        Collections.sort(rowsList, new Comparator(){

            public int compare(Object o1, Object o2) {
                List a0 = (List)o1;
                List a1 = (List)o2;
                EntityLayout entity0 = (EntityLayout)a0.get(0);
                EntityLayout entity1 = (EntityLayout)a1.get(0);
                return (int)(entity0.getLocation().y - entity1.getLocation().y);
            }
        });
        Comparator entityComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return (int)(((EntityLayout)o1).getLocation().y - ((EntityLayout)o2).getLocation().y);
            }
        };
        DisplayIndependentRectangle bounds = this.context.getBounds();
        int heightSoFar = 0;
        for (List currentRow : rowsList) {
            Collections.sort(currentRow, entityComparator);
            int i2 = 0;
            int width = (int)(bounds.width / 2.0 - (double)(currentRow.size() * 75));
            heightSoFar = (int)((double)heightSoFar + (((EntityLayout)currentRow.get((int)0)).getSize().height + 16.0));
            for (EntityLayout entity : currentRow) {
                DisplayIndependentDimension size = entity.getSize();
                entity.setLocation((double)(width + 10 * ++i2) + size.width / 2.0, (double)heightSoFar + size.height / 2.0);
                width = (int)((double)width + size.width);
            }
        }
    }

    @Override
    public void setLayoutContext(LayoutContext context) {
        this.context = context;
    }

    private void addToRowList(EntityLayout entity, ArrayList rowsList) {
        double layoutY = entity.getLocation().y;
        for (List currentRow : rowsList) {
            EntityLayout currentRowEntity = (EntityLayout)currentRow.get(0);
            double currentRowY = currentRowEntity.getLocation().y;
            if (!(layoutY >= currentRowY - 10.0) || !(layoutY <= currentRowY + 10.0)) continue;
            currentRow.add(entity);
            return;
        }
        ArrayList<EntityLayout> newRow = new ArrayList<EntityLayout>();
        newRow.add(entity);
        rowsList.add(newRow);
    }
}

