/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.widgets;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.constants.ColumnFilterType;
import org.netxms.client.log.ColumnFilter;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.logviewer.Messages;
import org.netxms.ui.eclipse.logviewer.widgets.ConditionEditor;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;

public class ObjectConditionEditor
extends ConditionEditor {
    private static final String[] OPERATIONS;
    private ObjectSelector objectSelector;

    static {
        String[] stringArray = new String[4];
        Messages.get();
        stringArray[0] = Messages.ObjectConditionEditor_Is;
        Messages.get();
        stringArray[1] = Messages.ObjectConditionEditor_IsNot;
        Messages.get();
        stringArray[2] = Messages.ObjectConditionEditor_Within;
        Messages.get();
        stringArray[3] = Messages.ObjectConditionEditor_NotWithin;
        OPERATIONS = stringArray;
    }

    public ObjectConditionEditor(Composite parent) {
        super(parent);
    }

    @Override
    protected String[] getOperations() {
        return OPERATIONS;
    }

    @Override
    protected void createContent(ColumnFilter initialFilter) {
        this.objectSelector = new ObjectSelector((Composite)this, 0, 2);
        this.objectSelector.setObjectClass(AbstractObject.class);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 0x1000000;
        this.objectSelector.setLayoutData((Object)gd);
        if (initialFilter != null) {
            switch (initialFilter.getType()) {
                case EQUALS: {
                    this.setSelectedOperation(initialFilter.isNegated() ? 1 : 0);
                    this.objectSelector.setObjectId(initialFilter.getNumericValue());
                    break;
                }
                case CHILDOF: {
                    this.setSelectedOperation(initialFilter.isNegated() ? 3 : 2);
                    this.objectSelector.setObjectId(initialFilter.getNumericValue());
                    break;
                }
            }
        }
    }

    @Override
    public ColumnFilter createFilter() {
        int op = this.getSelectedOperation();
        ColumnFilter filter = new ColumnFilter(op == 2 || op == 3 ? ColumnFilterType.CHILDOF : ColumnFilterType.EQUALS, this.objectSelector.getObjectId());
        filter.setNegated(op == 1 || op == 3);
        return filter;
    }
}

