/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.views.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.datacollection.TableThreshold;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Template;
import org.netxms.ui.eclipse.console.resources.DataCollectionDisplayInfo;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class DciLabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final Color FONT_COLOR = new Color((Device)Display.getDefault(), new RGB(126, 137, 185));
    private NXCSession session;
    private Image[] statusImages;
    private HashMap<DataOrigin, String> originTexts = new HashMap();
    private HashMap<Integer, String> statusTexts = new HashMap();

    public DciLabelProvider() {
        this.session = ConsoleSharedData.getSession();
        this.statusImages = new Image[3];
        this.statusImages[0] = Activator.getImageDescriptor("icons/active.gif").createImage();
        this.statusImages[1] = Activator.getImageDescriptor("icons/disabled.gif").createImage();
        this.statusImages[2] = Activator.getImageDescriptor("icons/unsupported.gif").createImage();
        Messages.get();
        this.originTexts.put(DataOrigin.AGENT, Messages.DciLabelProvider_SourceAgent);
        Messages.get();
        this.originTexts.put(DataOrigin.DEVICE_DRIVER, Messages.DciLabelProvider_SourceDeviceDriver);
        Messages.get();
        this.originTexts.put(DataOrigin.INTERNAL, Messages.DciLabelProvider_SourceInternal);
        this.originTexts.put(DataOrigin.MODBUS, "Modbus");
        Messages.get();
        this.originTexts.put(DataOrigin.MQTT, Messages.DciLabelProvider_SourceMQTT);
        Messages.get();
        this.originTexts.put(DataOrigin.PUSH, Messages.DciLabelProvider_SourcePush);
        Messages.get();
        this.originTexts.put(DataOrigin.SCRIPT, Messages.DciLabelProvider_SourceScript);
        Messages.get();
        this.originTexts.put(DataOrigin.SMCLP, Messages.DciLabelProvider_SourceILO);
        Messages.get();
        this.originTexts.put(DataOrigin.SNMP, Messages.DciLabelProvider_SourceSNMP);
        Messages.get();
        this.originTexts.put(DataOrigin.SSH, Messages.DciLabelProvider_SourceSSH);
        Messages.get();
        this.originTexts.put(DataOrigin.WEB_SERVICE, Messages.DciLabelProvider_SourceWebService);
        Messages.get();
        this.originTexts.put(DataOrigin.WINPERF, Messages.DciLabelProvider_SourceWinPerf);
        Integer n = 0;
        Messages.get();
        this.statusTexts.put(n, Messages.DciLabelProvider_Active);
        Integer n2 = 1;
        Messages.get();
        this.statusTexts.put(n2, Messages.DciLabelProvider_Disabled);
        Integer n3 = 2;
        Messages.get();
        this.statusTexts.put(n3, Messages.DciLabelProvider_NotSupported);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0) {
            return null;
        }
        int status = ((DataCollectionObject)element).getStatus();
        return status >= 0 && status < this.statusImages.length ? this.statusImages[status] : null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DataCollectionObject dci = (DataCollectionObject)element;
        switch (columnIndex) {
            case 0: {
                return Long.toString(dci.getId());
            }
            case 2: {
                return this.originTexts.get(dci.getOrigin());
            }
            case 1: {
                return dci.getDescription();
            }
            case 3: {
                return dci.getName();
            }
            case 5: {
                if (dci instanceof DataCollectionItem) {
                    return DataCollectionDisplayInfo.getDataTypeName((DataType)((DataCollectionItem)dci).getDataType());
                }
                Messages.get();
                return Messages.DciLabelProvider_Table;
            }
            case 4: {
                if (dci instanceof DataCollectionItem) {
                    String unitName = ((DataCollectionItem)dci).getUnitName();
                    return unitName == null ? "" : unitName;
                }
                return "";
            }
            case 6: {
                if (dci.isUseAdvancedSchedule()) {
                    Messages.get();
                    return Messages.DciLabelProvider_CustomSchedule;
                }
                if (dci.getPollingScheduleType() == 0) {
                    Messages.get();
                    return Messages.DciLabelProvider_Default;
                }
                return dci.getPollingInterval();
            }
            case 7: {
                if (dci.getRetentionType() == 2) {
                    Messages.get();
                    return Messages.DciLabelProvider_None;
                }
                if (dci.getRetentionType() == 0) {
                    Messages.get();
                    return Messages.DciLabelProvider_Default;
                }
                try {
                    String string;
                    int days = Integer.parseInt(dci.getRetentionTime());
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(Integer.toString(days)));
                    if (days == 1) {
                        Messages.get();
                        string = Messages.DciLabelProvider_Day;
                    } else {
                        Messages.get();
                        string = Messages.DciLabelProvider_Days;
                    }
                    return stringBuilder.append(string).toString();
                }
                catch (NumberFormatException e) {
                    return dci.getRetentionTime();
                }
            }
            case 8: {
                return this.statusTexts.get(dci.getStatus());
            }
            case 9: {
                int i;
                List list;
                StringBuilder thresholds = new StringBuilder();
                if (dci instanceof DataCollectionItem) {
                    list = ((DataCollectionItem)dci).getThresholds();
                    i = 0;
                    while (i < ((ArrayList)list).size()) {
                        Threshold tr = (Threshold)((ArrayList)list).get(i);
                        thresholds.append(tr.getTextualRepresentation());
                        if (i < ((ArrayList)list).size() - 1) {
                            thresholds.append(", ");
                        }
                        ++i;
                    }
                }
                if (dci instanceof DataCollectionTable) {
                    list = ((DataCollectionTable)dci).getThresholds();
                    i = 0;
                    while (i < list.size()) {
                        thresholds.append(((TableThreshold)list.get(i)).getConditionAsText());
                        if (i + 1 != list.size()) {
                            thresholds.append(", ");
                        }
                        ++i;
                    }
                }
                return thresholds.toString();
            }
            case 10: {
                if (dci.getTemplateId() == 0L) {
                    return null;
                }
                AbstractObject object = this.session.findObjectById(dci.getTemplateId());
                if (object == null) {
                    Messages.get();
                    return Messages.DciLabelProvider_Unknown;
                }
                if (!(object instanceof Template)) {
                    return object.getObjectName();
                }
                List parents = object.getParentChain(null);
                Collections.reverse(parents);
                StringBuilder sb = new StringBuilder();
                for (AbstractObject parent : parents) {
                    sb.append(parent.getObjectName());
                    sb.append("/");
                }
                sb.append(object.getObjectName());
                return sb.toString();
            }
            case 11: {
                if (dci.getRelatedObject() == 0L) {
                    return null;
                }
                AbstractObject obj = this.session.findObjectById(dci.getRelatedObject());
                if (obj == null) {
                    return "[" + dci.getRelatedObject() + "]";
                }
                return obj.getObjectName();
            }
            case 12: {
                if (dci instanceof DataCollectionItem) {
                    return ((DataCollectionItem)dci).isUsedForNodeStatusCalculation() ? "Yes" : "No";
                }
                return "No";
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        int i = 0;
        while (i < this.statusImages.length) {
            this.statusImages[i].dispose();
            ++i;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Color getForeground(Object element) {
        if (((DataCollectionObject)element).getTemplateId() != 0L) {
            return FONT_COLOR;
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

