/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.client.users.UserGroup;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class UserComparator
extends ViewerComparator {
    private int compareTypes(Object o1, Object o2) {
        int type1 = o1 instanceof UserGroup ? 1 : 0;
        int type2 = o2 instanceof UserGroup ? 1 : 0;
        return type1 - type2;
    }

    private String getFullName(Object object) {
        if (object instanceof User) {
            return ((User)object).getFullName();
        }
        return "";
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        switch ((Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID")) {
            case 5: {
                int m1 = e1 instanceof User ? ((User)e1).getAuthMethod().getValue() : -1;
                int m2 = e2 instanceof User ? ((User)e2).getAuthMethod().getValue() : -1;
                result = m1 - m2;
                break;
            }
            case 3: {
                result = ((AbstractUserObject)e1).getDescription().compareToIgnoreCase(((AbstractUserObject)e2).getDescription());
                break;
            }
            case 2: {
                result = this.getFullName(e1).compareToIgnoreCase(this.getFullName(e2));
                break;
            }
            case 6: {
                result = ((AbstractUserObject)e1).getGuid().toString().compareTo(((AbstractUserObject)e2).getGuid().toString());
                break;
            }
            case 7: {
                result = ((AbstractUserObject)e1).getLdapDn().compareToIgnoreCase(((AbstractUserObject)e2).getLdapDn());
                break;
            }
            case 0: {
                result = ((AbstractUserObject)e1).getName().compareToIgnoreCase(((AbstractUserObject)e2).getName());
                break;
            }
            case 4: {
                int s1 = (((AbstractUserObject)e1).getFlags() & 0x80) != 0 ? 1 : 0;
                int s2 = (((AbstractUserObject)e2).getFlags() & 0x80) != 0 ? 1 : 0;
                result = s1 - s2;
                break;
            }
            case 1: {
                result = this.compareTypes(e1, e2);
                break;
            }
            case 8: {
                int l1 = e1 instanceof User ? ((User)e1).getLastLogin().getSeconds() : -1;
                int l2 = e2 instanceof User ? ((User)e2).getLastLogin().getSeconds() : -1;
                result = l1 - l2;
                break;
            }
            case 9: {
                result = Long.signum(((AbstractUserObject)e1).getCreationTime().getSeconds() - ((AbstractUserObject)e2).getCreationTime().getSeconds());
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }
}

