/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.widgets;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class YAxisRangeEditor
extends Composite {
    private Button radioAuto;
    private Button radioManual;
    private Button checkYBase;
    private LabeledText from;
    private LabeledText to;
    private Color errorBackground;

    public YAxisRangeEditor(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        Group group = new Group((Composite)this, 0);
        Messages.get();
        group.setText(Messages.YAxisRangeEditor_Title);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        this.radioAuto = new Button((Composite)group, 16);
        Messages.get();
        this.radioAuto.setText(Messages.YAxisRangeEditor_Automatic);
        this.radioAuto.setSelection(true);
        this.checkYBase = new Button((Composite)group, 32);
        this.checkYBase.setText("Set Y base to min value");
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.checkYBase.setLayoutData((Object)gd);
        this.radioManual = new Button((Composite)group, 16);
        Messages.get();
        this.radioManual.setText(Messages.YAxisRangeEditor_Manual);
        this.from = new LabeledText((Composite)group, 0);
        Messages.get();
        this.from.setLabel(Messages.YAxisRangeEditor_From);
        this.from.setText("0");
        gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.from.setLayoutData((Object)gd);
        this.to = new LabeledText((Composite)group, 0);
        Messages.get();
        this.to.setLabel(Messages.YAxisRangeEditor_To);
        this.to.setText("100");
        gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.to.setLayoutData((Object)gd);
        SelectionAdapter s = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                YAxisRangeEditor.this.onModeChange();
            }
        };
        this.radioAuto.addSelectionListener((SelectionListener)s);
        this.radioManual.addSelectionListener((SelectionListener)s);
        this.errorBackground = new Color((Device)this.getDisplay(), 255, 64, 64);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                YAxisRangeEditor.this.errorBackground.dispose();
            }
        });
        ModifyListener inputValidator = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    Double.parseDouble(((Text)e.widget).getText().trim());
                    ((Text)e.widget).setBackground(null);
                }
                catch (NumberFormatException ex) {
                    ((Text)e.widget).setBackground(YAxisRangeEditor.this.errorBackground);
                }
            }
        };
        this.from.getTextControl().addModifyListener(inputValidator);
        this.to.getTextControl().addModifyListener(inputValidator);
        this.onModeChange();
    }

    private void onModeChange() {
        boolean auto = this.radioAuto.getSelection();
        this.checkYBase.setEnabled(auto);
        this.from.setEnabled(!auto);
        this.to.setEnabled(!auto);
        if (auto) {
            this.from.getTextControl().setBackground(null);
            this.to.getTextControl().setBackground(null);
        } else {
            try {
                Double.parseDouble(this.from.getText().trim());
            }
            catch (NumberFormatException ex) {
                this.from.getTextControl().setBackground(this.errorBackground);
            }
            try {
                Double.parseDouble(this.to.getText().trim());
            }
            catch (NumberFormatException ex) {
                this.to.getTextControl().setBackground(this.errorBackground);
            }
        }
    }

    public void setSelection(boolean auto, boolean modifyYBase, double minY, double maxY) {
        this.radioAuto.setSelection(auto);
        this.checkYBase.setSelection(auto && modifyYBase);
        this.radioManual.setSelection(!auto);
        this.from.setText(Double.toString(minY));
        this.to.setText(Double.toString(maxY));
        this.onModeChange();
    }

    public boolean isAuto() {
        return this.radioAuto.getSelection();
    }

    public boolean modifyYBase() {
        return this.checkYBase.getSelection();
    }

    public double getMinY() {
        try {
            return Double.parseDouble(this.from.getText().trim());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public double getMaxY() {
        try {
            return Double.parseDouble(this.to.getText().trim());
        }
        catch (NumberFormatException e) {
            return 100.0;
        }
    }

    public boolean validate(boolean showErrorMessage) {
        if (this.isAuto()) {
            return true;
        }
        try {
            Double.parseDouble(this.from.getText().trim());
            Double.parseDouble(this.to.getText().trim());
            return true;
        }
        catch (NumberFormatException e) {
            if (showErrorMessage) {
                MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Y axis range is invalid. Please enter correct values.");
            }
            return false;
        }
    }
}

