/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.widgets;

import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.ui.eclipse.charts.api.DataSeries;
import org.netxms.ui.eclipse.charts.widgets.Chart;
import org.netxms.ui.eclipse.charts.widgets.GenericComparisonChart;
import org.netxms.ui.eclipse.tools.ColorConverter;

public abstract class GenericGauge
extends GenericComparisonChart {
    protected static final int OUTER_MARGIN_WIDTH = 5;
    protected static final int OUTER_MARGIN_HEIGHT = 5;
    protected static final int INNER_MARGIN_WIDTH = 5;
    protected static final int INNER_MARGIN_HEIGHT = 5;
    protected static final RGB GREEN_ZONE_COLOR = new RGB(20, 156, 74);
    protected static final RGB YELLOW_ZONE_COLOR = new RGB(253, 200, 14);
    protected static final RGB RED_ZONE_COLOR = new RGB(226, 13, 52);

    public GenericGauge(Chart parent) {
        super(parent);
    }

    @Override
    protected void render(GC gc) {
        block13: {
            List<DataSeries> series;
            int hc;
            int wc;
            int dy;
            int dx;
            List<GraphItem> items;
            ChartConfiguration config;
            int top;
            Point size;
            block12: {
                int i;
                size = this.getSize();
                top = 5;
                config = this.chart.getConfiguration();
                items = this.chart.getItems();
                if (items.size() == 0 || size.x < 10 || size.y < 10) {
                    return;
                }
                if (config.isElementBordersVisible()) {
                    dx = 5;
                    dy = 5;
                    wc = -10;
                    hc = -10;
                } else {
                    hc = 0;
                    wc = 0;
                    dy = 0;
                    dx = 0;
                }
                series = this.chart.getDataSeries();
                if (!config.isTransposed()) break block12;
                int w = size.x - 10;
                int h = (size.y - 5 - top) / items.size();
                Point minSize = this.getMinElementSize();
                if (w < minSize.x || h < minSize.x) break block13;
                Object renderData = this.createRenderData();
                if (renderData != null) {
                    i = 0;
                    while (i < items.size()) {
                        this.prepareElementRender(gc, config, renderData, items.get(i), series.get(i), dx, top + i * h + dy, w + wc, h + hc, i);
                        ++i;
                    }
                }
                i = 0;
                while (i < items.size()) {
                    this.renderElement(gc, config, renderData, items.get(i), series.get(i), dx, top + i * h + dy, w + wc, h + hc, i);
                    if (config.isElementBordersVisible()) {
                        gc.setForeground(this.chart.getColorFromPreferences("Chart.Axis.Y.Color"));
                        gc.drawRectangle(0, top + i * h, w, h);
                    }
                    ++i;
                }
                break block13;
            }
            int w = (size.x - 10) / items.size();
            int h = size.y - 5 - top;
            Point minSize = this.getMinElementSize();
            if (w >= minSize.x && h >= minSize.x) {
                int i;
                Object renderData = this.createRenderData();
                if (renderData != null) {
                    i = 0;
                    while (i < items.size()) {
                        this.prepareElementRender(gc, config, renderData, items.get(i), series.get(i), i * w + dx, top + dy, w + wc, h + hc, i);
                        ++i;
                    }
                }
                i = 0;
                while (i < items.size()) {
                    this.renderElement(gc, config, renderData, items.get(i), series.get(i), i * w + dx, top + dy, w + wc, h + hc, i);
                    if (config.isElementBordersVisible()) {
                        gc.setForeground(this.chart.getColorFromPreferences("Chart.Axis.Y.Color"));
                        gc.drawRectangle(i * w, top, w, h);
                    }
                    ++i;
                }
            }
        }
    }

    protected Point getMinElementSize() {
        return new Point(10, 10);
    }

    protected Object createRenderData() {
        return null;
    }

    protected void prepareElementRender(GC gc, ChartConfiguration configuration, Object renderData, GraphItem dci, DataSeries data, int x, int y, int w, int h, int index) {
    }

    protected abstract void renderElement(GC var1, ChartConfiguration var2, Object var3, GraphItem var4, DataSeries var5, int var6, int var7, int var8, int var9, int var10);

    protected RGB getDataSourceColor(GraphItem dataSource, int index) {
        int c = dataSource.getColor();
        return c != -1 ? ColorConverter.rgbFromInt((int)c) : this.chart.getPaletteEntry(index).getRGBObject();
    }
}

