/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.PredictionEngine;
import org.netxms.ui.eclipse.datacollection.propertypages.helpers.AbstractDCIPropertyPage;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class Analytics
extends AbstractDCIPropertyPage {
    private DataCollectionItem dci;
    private Combo predictionEngine;
    private List<PredictionEngine> engines;

    public Analytics() {
        try {
            this.engines = ConsoleSharedData.getSession().getPredictionEngines();
        }
        catch (Exception e) {
            this.engines = new ArrayList<PredictionEngine>(0);
        }
    }

    @Override
    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dci = this.editor.getObjectAsItem();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.predictionEngine = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Prediction engine", (Object)new GridData(4, 0x1000000, true, false));
        this.predictionEngine.add("None");
        for (PredictionEngine e : this.engines) {
            this.predictionEngine.add(e.getDescription());
            if (!e.getName().equals(this.dci.getPredictionEngine())) continue;
            this.predictionEngine.select(this.predictionEngine.getItemCount() - 1);
        }
        if (this.predictionEngine.getSelectionIndex() == -1) {
            this.predictionEngine.select(0);
        }
        return dialogArea;
    }

    protected void applyChanges(boolean isApply) {
        int index = this.predictionEngine.getSelectionIndex();
        this.dci.setPredictionEngine(index > 0 ? this.engines.get(index - 1).getName() : "");
        this.editor.modify();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.predictionEngine.select(0);
    }
}

