/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DciValue;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ForceDciPoll
implements IObjectActionDelegate {
    private IWorkbenchPart part;
    private Set<DCI> objects = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
    }

    public void run(IAction action) {
        if (this.objects == null) {
            return;
        }
        final NXCSession session = ConsoleSharedData.getSession();
        final Set<DCI> dciToPoll = this.objects;
        Messages.get();
        new ConsoleJob(Messages.ForceDciPoll_TaskName, this.part, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Messages.get();
                monitor.beginTask(Messages.ForceDciPoll_TaskName, dciToPoll.size());
                for (DCI d : dciToPoll) {
                    session.forceDCIPoll(d.nodeId, d.dciId);
                    monitor.worked(1);
                }
                monitor.done();
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ForceDciPoll_ErrorText;
            }
        }.start();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        HashSet<DCI> dciList = null;
        if (selection instanceof IStructuredSelection) {
            dciList = new HashSet<DCI>();
            for (Object o : ((IStructuredSelection)selection).toList()) {
                if (o instanceof DciValue) {
                    dciList.add(new DCI(((DciValue)o).getNodeId(), ((DciValue)o).getId()));
                    continue;
                }
                if (o instanceof DataCollectionObject) {
                    dciList.add(new DCI(((DataCollectionObject)o).getNodeId(), ((DataCollectionObject)o).getId()));
                    continue;
                }
                dciList = null;
                break;
            }
        }
        this.objects = dciList;
        action.setEnabled(this.objects != null && this.objects.size() > 0);
    }

    private class DCI {
        long nodeId;
        long dciId;

        public DCI(long nodeId, long dciId) {
            this.nodeId = nodeId;
            this.dciId = dciId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.dciId ^ this.dciId >>> 32);
            result = 31 * result + (int)(this.nodeId ^ this.nodeId >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DCI other = (DCI)obj;
            if (this.dciId != other.dciId) {
                return false;
            }
            return this.nodeId == other.nodeId;
        }
    }
}

