/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.SoftwarePackage;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.modules.objects.widgets.helpers.DecoratingObjectLabelProvider;
import org.netxms.nxmc.modules.objects.widgets.helpers.SoftwareInventoryNode;
import org.netxms.nxmc.resources.ResourceManager;

public class SoftwarePackageLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private Image imgPackage;
    private boolean treeMode;
    private DecoratingObjectLabelProvider objectLabelProvider;

    public SoftwarePackageLabelProvider(boolean treeMode) {
        this.treeMode = treeMode;
        this.objectLabelProvider = new DecoratingObjectLabelProvider();
        this.imgPackage = ResourceManager.getImageDescriptor((String)"icons/package.png").createImage();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof SoftwareInventoryNode) {
                return this.objectLabelProvider.getImage((Object)((SoftwareInventoryNode)element).getNode());
            }
            if (this.treeMode && element instanceof SoftwarePackage) {
                return this.imgPackage;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof SoftwareInventoryNode) {
            if (columnIndex == 0) {
                return ((SoftwareInventoryNode)element).getNode().getObjectName();
            }
        } else {
            SoftwarePackage p = (SoftwarePackage)element;
            switch (columnIndex) {
                case 3: {
                    if (p.getInstallDate() == null || p.getInstallDate().getTime() == 0L) {
                        return null;
                    }
                    return DateFormatFactory.getDateFormat().format(p.getInstallDate());
                }
                case 4: {
                    return p.getDescription();
                }
                case 0: {
                    return p.getName();
                }
                case 5: {
                    return p.getSupportUrl();
                }
                case 2: {
                    return p.getVendor();
                }
                case 1: {
                    return p.getVersion();
                }
            }
        }
        return null;
    }

    public void dispose() {
        this.objectLabelProvider.dispose();
        this.imgPackage.dispose();
        super.dispose();
    }
}

