/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.constants.RoutingProtocol;
import org.netxms.client.topology.Route;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.helpers.RoutingTableLabelProvider;
import org.xnap.commons.i18n.I18n;

public class RoutingTableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final I18n i18n = LocalizationHelper.getI18n(RoutingTableLabelProvider.class);

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        Route r = (Route)element;
        switch (columnIndex) {
            case 0: {
                return r.getDestination().toString();
            }
            case 2: {
                return r.getIfName();
            }
            case 4: {
                return Integer.toString(r.getMetric());
            }
            case 1: {
                return r.getNextHop().getHostAddress();
            }
            case 5: {
                return this.getProtocolName(r.getProtocol());
            }
            case 3: {
                return Integer.toString(r.getType());
            }
        }
        return null;
    }

    private String getProtocolName(RoutingProtocol protocol) {
        switch (1.$SwitchMap$org$netxms$client$constants$RoutingProtocol[protocol.ordinal()]) {
            case 1: {
                return "BBN SPF IGP";
            }
            case 2: {
                return "ES-IS";
            }
            case 3: {
                return "IS-IS";
            }
            case 4: {
                return this.i18n.tr("Local");
            }
            case 5: {
                return this.i18n.tr("Network Management");
            }
            case 6: {
                return this.i18n.tr("Other");
            }
            case 7: {
                return this.i18n.tr("Unknown");
            }
        }
        return protocol.toString();
    }
}

