/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Dashboard;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.xnap.commons.i18n.I18n;

public class DashboardObjectContext
extends ObjectPropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(DashboardObjectContext.class);
    private Dashboard dashboard;
    private Button checkboxShowContextSelector;
    private Button checkboxShowAsObjectView;
    private LabeledSpinner displayPriority;

    public DashboardObjectContext(AbstractObject object) {
        super(LocalizationHelper.getI18n(DashboardObjectContext.class).tr("Object Context"), object);
    }

    public String getId() {
        return "dashboard-object-context";
    }

    public boolean isVisible() {
        return this.object instanceof Dashboard;
    }

    public int getPriority() {
        return 20;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.dashboard = (Dashboard)this.object;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkboxShowContextSelector = new Button(dialogArea, 32);
        this.checkboxShowContextSelector.setText(this.i18n.tr("Show &context selector in dashboard perspective"));
        this.checkboxShowContextSelector.setSelection((this.dashboard.getFlags() & 0x40000) != 0);
        this.checkboxShowContextSelector.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.checkboxShowAsObjectView = new Button(dialogArea, 32);
        this.checkboxShowAsObjectView.setText(this.i18n.tr("&Automatically show this dashboard in object context"));
        this.checkboxShowAsObjectView.setSelection((this.dashboard.getFlags() & 0x10000) != 0);
        this.checkboxShowAsObjectView.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.displayPriority = new LabeledSpinner(dialogArea, 0);
        this.displayPriority.setLabel(this.i18n.tr("Display priority (1-65535, 0 for automatic)"));
        this.displayPriority.setRange(0, 65535);
        this.displayPriority.setSelection(this.dashboard.getDisplayPriority());
        this.displayPriority.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        int flags = 0;
        if (this.checkboxShowContextSelector.getSelection()) {
            flags |= 0x40000;
        }
        if (this.checkboxShowAsObjectView.getSelection()) {
            flags |= 0x10000;
        }
        NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setObjectFlags(flags, 327680);
        md.setDisplayPriority(Integer.valueOf(this.displayPriority.getSelection()));
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }
}

