/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.widgets;

import java.util.HashMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.events.EventTemplate;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.dialogs.EditEventTemplateDialog;
import org.netxms.nxmc.modules.events.widgets.helpers.EventTemplateComparator;
import org.netxms.nxmc.modules.events.widgets.helpers.EventTemplateFilter;
import org.netxms.nxmc.modules.events.widgets.helpers.EventTemplateLabelProvider;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class EventTemplateList
extends Composite
implements SessionListener {
    private final I18n i18n = LocalizationHelper.getI18n(EventTemplateList.class);
    public static final int COLUMN_CODE = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_SEVERITY_OR_TAGS = 2;
    public static final int COLUMN_FLAGS = 3;
    public static final int COLUMN_MESSAGE = 4;
    public static final int COLUMN_TAGS = 5;
    private HashMap<Long, EventTemplate> eventTemplates;
    private SortableTableViewer viewer;
    private Action actionNew;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionDuplicate;
    private Action actionFindReferences;
    private Action actionRefresh;
    private NXCSession session;
    private EventTemplateFilter filter;
    private View view;

    public EventTemplateList(View view, Composite parent, int style, String configPrefix) {
        this(parent, style, configPrefix, false);
        this.view = view;
    }

    public EventTemplateList(Composite parent, int style, String configPrefix, boolean isDialog) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.session = Registry.getSession();
        String[] names = new String[]{this.i18n.tr("Code"), this.i18n.tr("Name"), this.i18n.tr("Severity"), this.i18n.tr("Flags"), this.i18n.tr("Message"), this.i18n.tr("Tags")};
        int[] widths = new int[]{70, 200, 90, 50, 400, 300};
        String[] dialogNames = new String[]{this.i18n.tr("Code"), this.i18n.tr("Name"), this.i18n.tr("Tags")};
        int[] dialogWidths = new int[]{70, 200, 300};
        this.viewer = new SortableTableViewer((Composite)this, isDialog ? dialogNames : names, isDialog ? dialogWidths : widths, 0, 128, 68354);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)configPrefix);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new EventTemplateLabelProvider(isDialog));
        this.viewer.setComparator((ViewerComparator)new EventTemplateComparator(isDialog));
        this.filter = new EventTemplateFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getControl().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createPopupMenu();
        this.refreshView();
        this.session.addListener((SessionListener)this);
    }

    private void refreshView() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void notificationHandler(SessionNotification n) {
        if (this.isDisposed()) {
            return;
        }
        switch (n.getCode()) {
            case 1013: {
                this.getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                break;
            }
            case 1014: {
                this.getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    private void createActions() {
        this.actionNew = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEdit.setEnabled(false);
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDelete.setEnabled(false);
        this.actionDuplicate = new /* Unavailable Anonymous Inner Class!! */;
        this.actionFindReferences = new /* Unavailable Anonymous Inner Class!! */;
        this.actionRefresh = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionNew);
        mgr.add((IAction)this.actionDuplicate);
        mgr.add((IAction)this.actionEdit);
        mgr.add((IAction)this.actionDelete);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionFindReferences);
    }

    protected void createNewEventTemplate() {
        EventTemplate tmpl = new EventTemplate(0L);
        EditEventTemplateDialog dlg = new EditEventTemplateDialog(this.getShell().getShell(), tmpl, false);
        if (dlg.open() == 0) {
            this.modifyEventTemplate(tmpl);
        }
    }

    protected void duplicateEventTemplate() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        EventTemplate tmpl = new EventTemplate((EventTemplate)selection.getFirstElement());
        tmpl.setCode(0L);
        tmpl.setName(tmpl.getName() + "_COPY");
        EditEventTemplateDialog dlg = new EditEventTemplateDialog(this.getShell().getShell(), tmpl, true);
        if (dlg.open() == 0) {
            this.modifyEventTemplate(tmpl);
        }
    }

    protected void modifyEventTemplate(EventTemplate tmpl) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void editEventTemplate() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        EventTemplate tmpl = new EventTemplate((EventTemplate)selection.getFirstElement());
        EditEventTemplateDialog dlg = new EditEventTemplateDialog(this.getShell().getShell(), tmpl, false);
        if (dlg.open() == 0) {
            this.modifyEventTemplate(tmpl);
        }
    }

    protected void deleteEventTemplate() {
        String message;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        String string = message = selection.size() > 1 ? this.i18n.tr("Do you really wish to delete selected event templates?") : this.i18n.tr("Do you really wish to delete selected event template?");
        if (!MessageDialogHelper.openQuestion((Shell)this.getShell(), (String)this.i18n.tr("Confirm event template deletion"), (String)message)) {
            return;
        }
        EventTemplate[] deleteList = new EventTemplate[selection.size()];
        int i = 0;
        for (Object o : selection.toList()) {
            deleteList[i++] = (EventTemplate)o;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void findReferences() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        long eventCode = ((EventTemplate)selection.getFirstElement()).getCode();
        String eventName = ((EventTemplate)selection.getFirstElement()).getName();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public SortableTableViewer getViewer() {
        return this.viewer;
    }

    public AbstractViewerFilter getFilter() {
        return this.filter;
    }

    public Action getActionNewTemplate() {
        return this.actionNew;
    }

    public Action getActionEdit() {
        return this.actionEdit;
    }

    public Action getActionDelete() {
        return this.actionDelete;
    }

    public Action getActionRefresh() {
        return this.actionRefresh;
    }
}

