/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.widgets;

import java.util.Arrays;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.TableColumnDefinition;
import org.netxms.client.TableRow;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.widgets.BaseTableValueViewer;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.CellSelectionManager;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.TableContentProvider;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.TableItemComparator;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.TableLabelProvider;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.TableValueFilter;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public abstract class BaseTableValueViewer
extends Composite {
    private final I18n i18n = LocalizationHelper.getI18n(BaseTableValueViewer.class);
    protected NXCSession session;
    protected ObjectView view;
    protected String configId;
    protected TableValueFilter filter;
    protected Table currentData = null;
    protected SortableTableViewer viewer;
    protected TableLabelProvider labelProvider;
    protected CLabel errorLabel;
    protected CellSelectionManager cellSelectionManager;
    protected Action actionUseMultipliers;
    protected Action actionShowFilter;
    protected boolean saveTableSettings;

    public BaseTableValueViewer(Composite parent, int style, ObjectView view, String configSubId) {
        this(parent, style, view, configSubId, false);
    }

    public BaseTableValueViewer(Composite parent, int style, ObjectView view, String configSubId, boolean saveTableSettings) {
        super(parent, style);
        this.view = view;
        this.saveTableSettings = saveTableSettings;
        this.setupLocalization();
        this.configId = this.buildConfigId(configSubId);
        this.session = Registry.getSession();
        this.setLayout((Layout)new FillLayout());
        this.viewer = new SortableTableViewer((Composite)this, 65538);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.labelProvider = new TableLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.filter = new TableValueFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.cellSelectionManager = new CellSelectionManager(this.viewer);
        PreferenceStore ds = PreferenceStore.getInstance();
        this.labelProvider.setUseMultipliers(ds.getAsBoolean(this.configId + ".useMultipliers", false));
        if (saveTableSettings) {
            this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.createActions();
        this.createPopupMenu();
    }

    protected abstract void setupLocalization();

    protected String buildConfigId(String configSubId) {
        return "BaseTableValueViewer." + configSubId;
    }

    protected void createActions() {
        this.actionUseMultipliers = new /* Unavailable Anonymous Inner Class!! */;
        this.actionUseMultipliers.setChecked(this.labelProvider.areMultipliersUsed());
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionUseMultipliers);
        manager.add((IContributionItem)new Separator());
    }

    protected void updateViewer(Table table) {
        PreferenceStore ds = PreferenceStore.getInstance();
        if (!this.viewer.isInitialized()) {
            String[] names = table.getColumnDisplayNames();
            int[] widths = new int[names.length];
            Arrays.fill(widths, 150);
            this.viewer.createColumns(names, widths, 0, 128);
            if (this.saveTableSettings) {
                WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)this.configId);
            }
            this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
            this.viewer.setComparator((ViewerComparator)new TableItemComparator(table.getColumnDataTypes()));
        }
        this.labelProvider.setColumns(table.getColumns());
        this.viewer.setInput((Object)table);
        if (!this.saveTableSettings) {
            this.viewer.packColumns();
        }
        this.currentData = table;
    }

    protected String buildInstanceString(ViewerRow viewerRow) {
        StringBuilder instance = new StringBuilder();
        TableRow row = (TableRow)viewerRow.getElement();
        boolean first = true;
        for (int i = 0; i < this.currentData.getColumnCount(); ++i) {
            TableColumnDefinition cd = this.currentData.getColumnDefinition(i);
            if (!cd.isInstanceColumn()) continue;
            if (!first) {
                instance.append("~~~");
            }
            instance.append(row.getValue(i));
            first = false;
        }
        return instance.toString();
    }

    public String getTitle() {
        return this.currentData != null ? this.currentData.getTitle() : "";
    }

    public SortableTableViewer getViewer() {
        return this.viewer;
    }

    public Action getActionUseMultipliers() {
        return this.actionUseMultipliers;
    }

    public void refresh(Runnable postRefreshHook) {
        this.viewer.setInput(null);
        5 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    public AbstractViewerFilter getFilter() {
        return this.filter;
    }

    protected abstract Table readData() throws Exception;

    protected abstract String getReadJobName();

    protected abstract String getReadJobErrorMessage();
}

