/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.dialogs;

import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.AgentParameter;
import org.netxms.client.AgentTable;
import org.netxms.client.constants.DataType;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.dialogs.IParameterSelectionDialog;
import org.netxms.nxmc.modules.datacollection.dialogs.helpers.AgentParameterComparator;
import org.netxms.nxmc.modules.datacollection.dialogs.helpers.AgentParameterFilter;
import org.netxms.nxmc.modules.datacollection.dialogs.helpers.AgentParameterLabelProvider;
import org.netxms.nxmc.modules.datacollection.dialogs.helpers.AgentTableComparator;
import org.netxms.nxmc.modules.datacollection.dialogs.helpers.AgentTableLabelProvider;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public abstract class AbstractSelectParamDlg
extends Dialog
implements IParameterSelectionDialog {
    private final I18n i18n = LocalizationHelper.getI18n(AbstractSelectParamDlg.class);
    public static final int COLUMN_DESCRIPTION = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_TYPE = 2;
    protected boolean selectTables;
    protected AbstractObject object;
    protected Text filterText;
    protected SortableTableViewer viewer;
    private Object selection;
    private AgentParameterFilter filter;

    public AbstractSelectParamDlg(Shell parentShell, long nodeId, boolean selectTables) {
        super(parentShell);
        this.selectTables = selectTables;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.object = Registry.getSession().findObjectById(nodeId);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.selectTables ? this.i18n.tr("Table Selection") : this.i18n.tr("Parameter Selection"));
        PreferenceStore settings = PreferenceStore.getInstance();
        String prefix = this.getConfigurationPrefix();
        try {
            newShell.setSize(settings.getAsPoint(prefix + ".size", 600, 400));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        label.setText(this.selectTables ? this.i18n.tr("Available tables") : this.i18n.tr("Available parameters"));
        this.filterText = new Text(dialogArea, 2048);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.filterText.setLayoutData((Object)gd);
        this.filterText.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        String[] names = new String[]{this.i18n.tr("Description"), this.i18n.tr("Name"), this.selectTables ? this.i18n.tr("Instance Column") : this.i18n.tr("Data Type")};
        int[] widths = new int[]{350, 150, this.selectTables ? 150 : 100};
        this.viewer = new SortableTableViewer(dialogArea, names, widths, 0, 128, 67584);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)(this.getConfigurationPrefix() + ".viewer"));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)(this.selectTables ? new AgentTableLabelProvider() : new AgentParameterLabelProvider()));
        this.viewer.setComparator((ViewerComparator)(this.selectTables ? new AgentTableComparator() : new AgentParameterComparator()));
        this.filter = new AgentParameterFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.getTable().addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createPopupMenu();
        gd = new GridData();
        gd.heightHint = 250;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.fillList();
        return dialogArea;
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
    }

    public DataType getParameterDataType() {
        return this.selectTables ? DataType.NULL : ((AgentParameter)this.selection).getDataType();
    }

    public String getParameterDescription() {
        return this.selectTables ? ((AgentTable)this.selection).getDescription() : ((AgentParameter)this.selection).getDescription();
    }

    public String getParameterName() {
        return this.selectTables ? ((AgentTable)this.selection).getName() : ((AgentParameter)this.selection).getName();
    }

    public String getInstanceColumn() {
        return this.selectTables ? ((AgentTable)this.selection).getInstanceColumnsAsList() : "";
    }

    protected void okPressed() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("You must select parameter from the list!"));
            return;
        }
        this.selection = selection.getFirstElement();
        this.saveSettings();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void saveSettings() {
        Point size = this.getShell().getSize();
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set(this.getConfigurationPrefix() + ".size", size);
    }

    protected abstract void fillList();

    protected abstract String getConfigurationPrefix();
}

