/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.GraphDefinition;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objecttools.ObjectContextBase;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewPlacement;
import org.netxms.nxmc.modules.datacollection.views.HistoricalGraphView;
import org.netxms.nxmc.modules.objects.ObjectContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphTemplateCache {
    private static final Logger logger = LoggerFactory.getLogger(GraphTemplateCache.class);
    private NXCSession session = null;
    private List<GraphDefinition> templateList = new ArrayList();

    public GraphTemplateCache(NXCSession session) {
        this.session = session;
        this.reload();
        session.addListener((SessionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static void attachSession(Display display, NXCSession session) {
        GraphTemplateCache instance = new GraphTemplateCache(session);
        Registry.setSingleton((Display)display, GraphTemplateCache.class, (Object)instance);
    }

    public static GraphTemplateCache getInstance() {
        return (GraphTemplateCache)Registry.getSingleton(GraphTemplateCache.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload() {
        try {
            List list = this.templateList;
            synchronized (list) {
                this.templateList.clear();
                this.templateList = this.session.getPredefinedGraphs(true);
            }
        }
        catch (Exception e) {
            logger.error("Exception in ObjectToolsCache.reload()", (Throwable)e);
        }
    }

    public GraphDefinition[] getGraphTemplates() {
        GraphDefinition[] graphs = this.templateList.toArray(new GraphDefinition[this.templateList.size()]);
        Arrays.sort(graphs, new /* Unavailable Anonymous Inner Class!! */);
        return graphs;
    }

    public static void instantiate(AbstractNode node, long contextId, GraphDefinition template, DciValue[] dciList, NXCSession session, ViewPlacement viewPlacement) throws IOException, NXCException {
        ArrayList<String> textsToExpand = new ArrayList<String>();
        textsToExpand.add(template.getTitle());
        String name = (String)session.substituteMacros((ObjectContextBase)new ObjectContext((AbstractObject)node, null, contextId), textsToExpand, new HashMap()).get(0);
        GraphDefinition graphDefinition = new GraphDefinition(template, name);
        HashSet<ChartDciConfig> chartMetrics = new HashSet<ChartDciConfig>();
        block0: for (ChartDciConfig dci : graphDefinition.getDciList()) {
            if (dci.regexMatch) {
                Pattern namePattern = Pattern.compile(dci.dciName);
                Pattern descriptionPattern = Pattern.compile(dci.dciDescription);
                for (int j = 0; j < dciList.length; ++j) {
                    Matcher nameMatch = namePattern.matcher(dciList[j].getName());
                    Matcher descriptionMatch = descriptionPattern.matcher(dciList[j].getDescription());
                    if ((dci.dciName.isEmpty() || !nameMatch.find()) && (dci.dciDescription.isEmpty() || !descriptionMatch.find())) continue;
                    chartMetrics.add(new ChartDciConfig(dci, !dci.dciName.isEmpty() && nameMatch.find() ? nameMatch : descriptionMatch, dciList[j]));
                    if (!dci.multiMatch) continue block0;
                }
                continue;
            }
            for (int j = 0; j < dciList.length; ++j) {
                if ((dci.dciName.isEmpty() || !dciList[j].getName().equalsIgnoreCase(dci.dciName)) && (dci.dciDescription.isEmpty() || !dciList[j].getDescription().equalsIgnoreCase(dci.dciDescription))) continue;
                chartMetrics.add(new ChartDciConfig(dci, dciList[j]));
                if (!dci.multiMatch) continue block0;
            }
        }
        Display display = viewPlacement.getWindow().getShell().getDisplay();
        if (!chartMetrics.isEmpty()) {
            display.syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            display.syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private static void showPredefinedGraph(GraphDefinition graphDefinition, AbstractNode node, long contextId, ViewPlacement viewPlacement) {
        HistoricalGraphView view = new HistoricalGraphView((AbstractObject)node, Arrays.asList(graphDefinition.getDciList()), contextId);
        viewPlacement.openView((View)view);
        view.initPredefinedGraph(graphDefinition);
    }
}

