/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.dialogs;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTreeViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.DashboardImporter;
import org.netxms.nxmc.modules.dashboards.dialogs.helpers.DciIdMatchingData;
import org.netxms.nxmc.modules.dashboards.dialogs.helpers.IdMatchingContentProvider;
import org.netxms.nxmc.modules.dashboards.dialogs.helpers.IdMatchingLabelProvider;
import org.netxms.nxmc.modules.dashboards.dialogs.helpers.ObjectIdMatchingData;
import org.netxms.nxmc.modules.datacollection.dialogs.SelectNodeDciDialog;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class IdMatchingDialog
extends Dialog {
    public static final int COLUMN_SOURCE_ID = 0;
    public static final int COLUMN_SOURCE_NAME = 1;
    public static final int COLUMN_DESTINATION_ID = 2;
    public static final int COLUMN_DESTINATION_NAME = 3;
    private final I18n i18n = LocalizationHelper.getI18n(IdMatchingDialog.class);
    private SortableTreeViewer viewer;
    private Map<Long, ObjectIdMatchingData> objects;
    private Map<Long, DciIdMatchingData> dcis;
    private Action actionMap;
    private boolean showFilterToolTip;

    public IdMatchingDialog(Shell parentShell, Map<Long, ObjectIdMatchingData> objects, Map<Long, DciIdMatchingData> dcis) {
        super(parentShell);
        this.objects = objects;
        this.dcis = dcis;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("ID Mapping Editor"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 64);
        label.setText(this.i18n.tr("Please check that source objects and data collection items correctly mapped to destination system. Incorrect mappings can be changed by selecting \"Map to...\" from appropriate item's context menu. When done, press \"OK\" to continue dashboard import or \"Cancel\" to cancel import process."));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 0;
        label.setLayoutData((Object)gd);
        String[] names = new String[]{this.i18n.tr("Original ID"), this.i18n.tr("Original Name"), this.i18n.tr("Match ID"), this.i18n.tr("Match Name")};
        int[] widths = new int[]{100, 300, 80, 300};
        this.viewer = new SortableTreeViewer(dialogArea, names, widths, 0, 128, 67588);
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.getTree().setHeaderVisible(true);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 400;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new IdMatchingContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new IdMatchingLabelProvider());
        this.viewer.setInput((Object)new Object[]{this.objects, this.dcis});
        this.viewer.expandAll();
        this.createActions();
        this.createPopupMenu();
        return dialogArea;
    }

    private void createActions() {
        this.actionMap = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void mapNode(ObjectIdMatchingData data) {
        HashSet<Integer> classFilter;
        switch (data.objectClass) {
            case 2: 
            case 14: 
            case 31: 
            case 33: 
            case 35: 
            case 37: {
                classFilter = ObjectSelectionDialog.createDataCollectionTargetSelectionFilter();
                this.showFilterToolTip = true;
                break;
            }
            case 5: 
            case 29: {
                classFilter = ObjectSelectionDialog.createContainerSelectionFilter();
                this.showFilterToolTip = false;
                break;
            }
            case 6: {
                classFilter = ObjectSelectionDialog.createZoneSelectionFilter();
                this.showFilterToolTip = true;
                break;
            }
            case 23: {
                classFilter = new HashSet<Integer>(2);
                classFilter.add(23);
                classFilter.add(22);
                break;
            }
            default: {
                classFilter = null;
            }
        }
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell(), classFilter);
        dlg.showFilterToolTip(this.showFilterToolTip);
        if (dlg.open() == 0) {
            AbstractObject object = (AbstractObject)dlg.getSelectedObjects().get(0);
            if (DashboardImporter.isCompatibleClasses((int)object.getObjectClass(), (int)data.objectClass)) {
                data.dstId = object.getObjectId();
                data.dstName = object.getObjectName();
                this.updateDciMapping(data);
                this.viewer.update((Object)data, null);
            } else {
                MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Target object must be of same class as source object."));
            }
        }
    }

    private void updateDciMapping(ObjectIdMatchingData objData) {
        if (objData.dcis.size() == 0) {
            return;
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void mapDci(DciIdMatchingData data) {
        DciValue v;
        if (data.dstNodeId == 0L) {
            return;
        }
        SelectNodeDciDialog dlg = new SelectNodeDciDialog(this.getShell(), data.dstNodeId);
        if (dlg.open() == 0 && (v = dlg.getSelection()) != null) {
            data.dstDciId = v.getId();
            data.dstName = v.getDescription();
            this.viewer.update((Object)data, null);
        }
    }

    protected void okPressed() {
        boolean ok = true;
        for (ObjectIdMatchingData o : this.objects.values()) {
            if (o.dstId != 0L) continue;
            ok = false;
            break;
        }
        for (DciIdMatchingData d : this.dcis.values()) {
            if (d.dstNodeId != 0L && d.dstDciId != 0L) continue;
            ok = false;
            break;
        }
        if (!ok && !MessageDialogHelper.openQuestion((Shell)this.getShell(), (String)this.i18n.tr("Matching Errors"), (String)this.i18n.tr("Not all elements was matched correctly to destination system. Imported dashboard will not behave correctly. Are you sure to continue dashboard import?"))) {
            return;
        }
        super.okPressed();
    }
}

