/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.charts.widgets;

import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.nxmc.modules.charts.api.DataSeries;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.charts.widgets.GenericComparisonChart;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.ColorConverter;

public abstract class GenericGauge
extends GenericComparisonChart {
    protected static final int OUTER_MARGIN_WIDTH = 5;
    protected static final int OUTER_MARGIN_HEIGHT = 5;
    protected static final int INNER_MARGIN_WIDTH = 5;
    protected static final int INNER_MARGIN_HEIGHT = 5;
    protected static final RGB GREEN_ZONE_COLOR = new RGB(20, 156, 74);
    protected static final RGB YELLOW_ZONE_COLOR = new RGB(253, 200, 14);
    protected static final RGB RED_ZONE_COLOR = new RGB(226, 13, 52);

    public GenericGauge(Chart parent) {
        super(parent);
    }

    protected void render(GC gc) {
        block11: {
            List series;
            int hc;
            int wc;
            int dy;
            int dx;
            List items;
            ChartConfiguration config;
            int top;
            Point size;
            block10: {
                int i;
                size = this.getSize();
                top = 5;
                config = this.chart.getConfiguration();
                items = this.chart.getItems();
                if (items.size() == 0 || size.x < 10 || size.y < 10) {
                    return;
                }
                if (config.isElementBordersVisible()) {
                    dx = 5;
                    dy = 5;
                    wc = -10;
                    hc = -10;
                } else {
                    hc = 0;
                    wc = 0;
                    dy = 0;
                    dx = 0;
                }
                series = this.chart.getDataSeries();
                if (!config.isTransposed()) break block10;
                int w = size.x - 10;
                int h = (size.y - 5 - top) / items.size();
                Point minSize = this.getMinElementSize();
                if (w < minSize.x || h < minSize.x) break block11;
                Object renderData = this.createRenderData();
                if (renderData != null) {
                    for (i = 0; i < items.size(); ++i) {
                        this.prepareElementRender(gc, config, renderData, (GraphItem)items.get(i), (DataSeries)series.get(i), dx, top + i * h + dy, w + wc, h + hc, i);
                    }
                }
                for (i = 0; i < items.size(); ++i) {
                    this.renderElement(gc, config, renderData, (GraphItem)items.get(i), (DataSeries)series.get(i), dx, top + i * h + dy, w + wc, h + hc, i);
                    if (!config.isElementBordersVisible()) continue;
                    gc.setForeground(ThemeEngine.getForegroundColor((String)"Chart.PlotArea"));
                    gc.drawRectangle(0, top + i * h, w, h);
                }
                break block11;
            }
            int w = (size.x - 10) / items.size();
            int h = size.y - 5 - top;
            Point minSize = this.getMinElementSize();
            if (w >= minSize.x && h >= minSize.x) {
                int i;
                Object renderData = this.createRenderData();
                if (renderData != null) {
                    for (i = 0; i < items.size(); ++i) {
                        this.prepareElementRender(gc, config, renderData, (GraphItem)items.get(i), (DataSeries)series.get(i), i * w + dx, top + dy, w + wc, h + hc, i);
                    }
                }
                for (i = 0; i < items.size(); ++i) {
                    this.renderElement(gc, config, renderData, (GraphItem)items.get(i), (DataSeries)series.get(i), i * w + dx, top + dy, w + wc, h + hc, i);
                    if (!config.isElementBordersVisible()) continue;
                    gc.setForeground(ThemeEngine.getForegroundColor((String)"Chart.PlotArea"));
                    gc.drawRectangle(i * w, top, w, h);
                }
            }
        }
    }

    protected Point getMinElementSize() {
        return new Point(10, 10);
    }

    protected Object createRenderData() {
        return null;
    }

    protected void prepareElementRender(GC gc, ChartConfiguration configuration, Object renderData, GraphItem dci, DataSeries data, int x, int y, int w, int h, int index) {
    }

    protected abstract void renderElement(GC var1, ChartConfiguration var2, Object var3, GraphItem var4, DataSeries var5, int var6, int var7, int var8, int var9, int var10);

    protected RGB getDataSourceColor(GraphItem dataSource, int index) {
        int c = dataSource.getColor();
        return c != -1 ? ColorConverter.rgbFromInt((int)c) : this.chart.getPaletteEntry(index).getRGBObject();
    }
}

