/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.tools.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ConnectionPointType;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.client.topology.ConnectionPoint;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.tools.widgets.helpers.ConnectionPointComparator;
import org.netxms.nxmc.modules.tools.widgets.helpers.ConnectionPointLabelProvider;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class SearchResult
extends Composite {
    private final I18n i18n = LocalizationHelper.getI18n(SearchResult.class);
    private static final Logger logger = LoggerFactory.getLogger(DashboardControl.class);
    public static final int COLUMN_SEQUENCE = 0;
    public static final int COLUMN_NODE = 1;
    public static final int COLUMN_INTERFACE = 2;
    public static final int COLUMN_MAC_ADDRESS = 3;
    public static final int COLUMN_NIC_VENDOR = 4;
    public static final int COLUMN_IP_ADDRESS = 5;
    public static final int COLUMN_SWITCH = 6;
    public static final int COLUMN_PORT = 7;
    public static final int COLUMN_INDEX = 8;
    public static final int COLUMN_TYPE = 9;
    private View view;
    private SortableTableViewer viewer;
    private List<ConnectionPoint> results = new ArrayList();
    private Action actionClearLog;
    private Action actionCopyMAC;
    private Action actionCopyIP;
    private Action actionCopyRecord;

    public SearchResult(View view, Composite parent, int style, String configPrefix) {
        super(parent, style);
        this.view = view;
        this.setLayout((Layout)new FillLayout());
        String[] names = new String[]{this.i18n.tr("Seq."), this.i18n.tr("Node"), this.i18n.tr("Interface"), this.i18n.tr("MAC"), this.i18n.tr("NIC vendor"), this.i18n.tr("IP"), this.i18n.tr("Switch"), this.i18n.tr("Port"), this.i18n.tr("Index"), this.i18n.tr("Type")};
        int[] widths = new int[]{70, 120, 120, 180, 90, 90, 120, 120, 60, 60};
        this.viewer = new SortableTableViewer((Composite)this, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ConnectionPointLabelProvider labelProvider = new ConnectionPointLabelProvider((TableViewer)this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setComparator((ViewerComparator)new ConnectionPointComparator((ITableLabelProvider)labelProvider));
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)configPrefix);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createPopupMenu();
    }

    private void createActions() {
        this.actionClearLog = new /* Unavailable Anonymous Inner Class!! */;
        this.actionClearLog.setImageDescriptor(SharedIcons.CLEAR_LOG);
        this.actionCopyIP = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyMAC = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyRecord = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopyRecord);
        manager.add((IAction)this.actionCopyIP);
        manager.add((IAction)this.actionCopyMAC);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionClearLog);
    }

    private void copyMacAddress() {
        List selection = this.viewer.getStructuredSelection().toList();
        if (selection.size() > 0) {
            String newLine = WidgetHelper.getNewLineCharacters();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < selection.size(); ++i) {
                if (i > 0) {
                    sb.append(newLine);
                }
                sb.append(((ConnectionPoint)selection.get(i)).getLocalMacAddress().toString());
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }

    private void copyToClipboard(int column) {
        TableItem[] selection = this.viewer.getTable().getSelection();
        if (selection.length > 0) {
            String newLine = WidgetHelper.getNewLineCharacters();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < selection.length; ++i) {
                if (i > 0) {
                    sb.append(newLine);
                }
                if (column == -1) {
                    for (int j = 0; j < this.viewer.getTable().getColumnCount(); ++j) {
                        if (j > 0) {
                            sb.append('\t');
                        }
                        sb.append(selection[i].getText(j));
                    }
                    continue;
                }
                sb.append(selection[i].getText(column));
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }

    public boolean setFocus() {
        return this.viewer.getTable().setFocus();
    }

    public void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionCopyRecord);
        manager.add((IAction)this.actionCopyIP);
        manager.add((IAction)this.actionCopyMAC);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionClearLog);
    }

    public void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCopyRecord);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionClearLog);
    }

    private void addResult(ConnectionPoint cp) {
        cp.setData((Object)this.results.size());
        this.results.add(cp);
        this.viewer.setInput((Object)this.results.toArray());
    }

    private void retireResults() {
        for (ConnectionPoint r : this.results) {
            r.setHistorical(true);
        }
        this.view.clearMessages();
    }

    public void showConnection(ConnectionPoint cp) {
        this.retireResults();
        if (cp == null) {
            this.view.addMessage(2, this.i18n.tr("Connection point information cannot be found"));
            return;
        }
        NXCSession session = Registry.getSession();
        if (session.areChildrenSynchronized(cp.getNodeId()) && session.areChildrenSynchronized(cp.getLocalNodeId())) {
            this.showConnectionStep2(session, cp);
        } else {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    private void showConnectionStep2(NXCSession session, ConnectionPoint cp) {
        try {
            Node host = (Node)session.findObjectById(cp.getLocalNodeId());
            Node bridge = (Node)session.findObjectById(cp.getNodeId());
            AbstractObject iface = session.findObjectById(cp.getInterfaceId());
            if (bridge != null && iface != null) {
                if (cp.getType() == ConnectionPointType.WIRELESS) {
                    if (host != null) {
                        this.view.addMessage(0, String.format(this.i18n.tr("Node %1$s is connected to wireless access point %2$s/%3$s"), host.getObjectName(), bridge.getObjectName(), iface.getObjectName()));
                    } else if (cp.getLocalIpAddress() != null) {
                        this.view.addMessage(0, String.format(this.i18n.tr("Node with IP address %1$s and MAC address %2$s is connected to wireless access point %3$s/%4$s"), cp.getLocalIpAddress().getHostAddress(), cp.getLocalMacAddress(), bridge.getObjectName(), iface.getObjectName()));
                    } else {
                        this.view.addMessage(0, String.format(this.i18n.tr("Node with MAC address %1$s is connected to wireless access point %2$s/%3$s"), cp.getLocalMacAddress(), bridge.getObjectName(), iface.getObjectName()));
                    }
                } else if (host != null) {
                    this.view.addMessage(0, String.format(this.i18n.tr("Node %1$s is %2$s connected to network switch %3$s port %4$s"), host.getObjectName(), cp.getType() == ConnectionPointType.DIRECT ? this.i18n.tr("directly") : this.i18n.tr("indirectly"), bridge.getObjectName(), iface.getObjectName()));
                } else if (cp.getLocalIpAddress() != null) {
                    this.view.addMessage(0, String.format(this.i18n.tr("Node with IP address %1$s and MAC address %2$s is %3$s connected to network switch %4$s port %5$s"), cp.getLocalIpAddress().getHostAddress(), cp.getLocalMacAddress(), cp.getType() == ConnectionPointType.DIRECT ? this.i18n.tr("directly") : this.i18n.tr("indirectly"), bridge.getObjectName(), iface.getObjectName()));
                } else {
                    this.view.addMessage(0, String.format(this.i18n.tr("Node with MAC address %1$s is %2$s connected to network switch %3$s port %4$s"), cp.getLocalMacAddress(), cp.getType() == ConnectionPointType.DIRECT ? this.i18n.tr("directly") : this.i18n.tr("indirectly"), bridge.getObjectName(), iface.getObjectName()));
                }
                this.addResult(cp);
            } else if (host != null && cp.getType() == ConnectionPointType.UNKNOWN) {
                this.view.addMessage(2, String.format("Found node %s but it's connection point is unknown", host.getObjectName()));
                this.addResult(cp);
            } else {
                this.view.addMessage(2, this.i18n.tr("Connection point information cannot be found"));
            }
        }
        catch (Exception e) {
            logger.error("Exception in host search result view", (Throwable)e);
            this.view.addMessage(2, String.format(this.i18n.tr("Connection point information cannot be shown: %s"), e.getLocalizedMessage()));
        }
    }

    public void showConnection(List<ConnectionPoint> cps) {
        this.retireResults();
        NXCSession session = Registry.getSession();
        if (session.areObjectsSynchronized()) {
            this.showConnectionStep2(session, cps);
        } else {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    public void showConnectionStep2(NXCSession session, List<ConnectionPoint> cps) {
        int counter = 0;
        try {
            for (ConnectionPoint p : cps) {
                if (p.getType() == ConnectionPointType.NOT_FOUND) {
                    ++counter;
                }
                this.addResult(p);
            }
            if (counter > 0) {
                this.view.addMessage(2, this.i18n.tr("Connection point information cannot be found") + " for " + counter + " interfaces!");
            }
        }
        catch (Exception e) {
            this.view.addMessage(2, String.format(this.i18n.tr("Connection point information cannot be shown: %s"), e.getLocalizedMessage()));
        }
    }

    public void copyResults(SearchResult serachResultWidget) {
        this.results = new ArrayList(serachResultWidget.results);
        this.viewer.setInput((Object)this.results.toArray());
    }
}

